/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.conf;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.MissingResourceException;
import junit.framework.TestCase;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.conf.ProductDerivations;
import org.apache.openjpa.lib.util.Options;

public class TestAnchorParsing
extends TestCase {
    public void testFQAnchor() {
        String fqLoc = "META-INF/persistence.xml#test";
        Options opts = new Options();
        opts.setProperty("p", fqLoc);
        List locs = Configurations.getFullyQualifiedAnchorsInPropertiesLocation((Options)opts);
        TestAnchorParsing.assertNotNull((Object)locs);
        TestAnchorParsing.assertEquals((int)1, (int)locs.size());
        TestAnchorParsing.assertEquals((String)fqLoc, (String)((String)locs.get(0)));
    }

    public void testNoResource() {
        this.allHelper(null);
    }

    public void testNoAnchor() {
        this.allHelper("META-INF/persistence.xml");
    }

    private void allHelper(String resource) {
        Options opts = new Options();
        if (resource != null) {
            opts.setProperty("p", resource);
        }
        List locs = Configurations.getFullyQualifiedAnchorsInPropertiesLocation((Options)opts);
        TestAnchorParsing.assertNotNull((Object)locs);
        TestAnchorParsing.assertTrue((locs.size() >= 4 ? 1 : 0) != 0);
        TestAnchorParsing.assertTrue((boolean)locs.contains("META-INF/persistence.xml#test"));
        TestAnchorParsing.assertTrue((boolean)locs.contains("META-INF/persistence.xml#second-persistence-unit"));
        TestAnchorParsing.assertTrue((boolean)locs.contains("META-INF/persistence.xml#third-persistence-unit"));
        TestAnchorParsing.assertTrue((boolean)locs.contains("META-INF/persistence.xml#invalid"));
    }

    public void testProductDerivationsLoadResource() {
        ProductDerivations.load((String)"org/apache/openjpa/lib/conf/product-derivations-load.xml", (String)"foo", null);
        ProductDerivations.load((String)"org/apache/openjpa/lib/conf/product-derivations-load.xml", null, null);
        try {
            ProductDerivations.load((String)"org/apache/openjpa/lib/conf/product-derivations-load.xml", (String)"nonexistant", null);
            TestAnchorParsing.fail((String)"pu 'nonexistant' does not exist");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            ProductDerivations.load((String)"org/apache/openjpa/lib/conf/product-derivations-load.xml", (String)"", null);
            TestAnchorParsing.fail((String)"pu '' does not exist");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    public void testNonexistantResourceLoad() {
        try {
            ProductDerivations.load((String)"nonexistant-resource", null, null);
            TestAnchorParsing.fail((String)"resource 'nonexistant-resource' should not exist");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    public void testProductDerivationsLoadFile() throws IOException {
        File validFile = this.resourceToTemporaryFile("org/apache/openjpa/lib/conf/product-derivations-load.xml");
        ProductDerivations.load((File)validFile, (String)"foo", null);
        ProductDerivations.load((File)validFile, null, null);
        try {
            ProductDerivations.load((File)validFile, (String)"nonexistant", null);
            TestAnchorParsing.fail((String)"pu 'nonexistant' does not exist");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            ProductDerivations.load((File)validFile, (String)"", null);
            TestAnchorParsing.fail((String)"pu '' does not exist");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        validFile = null;
    }

    public void testNonexistantFileLoad() {
        File f = new File("this-should-not-exist");
        TestAnchorParsing.assertFalse((boolean)f.exists());
        try {
            ProductDerivations.load((File)f, null, null);
            TestAnchorParsing.fail((String)(f.getName() + " does not exist"));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    private File resourceToTemporaryFile(String s) throws IOException {
        int count;
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(s);
        File f = File.createTempFile("TestAnchorParsing", ".xml");
        FileOutputStream out = new FileOutputStream(f);
        byte[] bytes = new byte[1024];
        while ((count = in.read(bytes)) >= 0) {
            ((OutputStream)out).write(bytes, 0, count);
        }
        in.close();
        ((OutputStream)out).close();
        f.deleteOnExit();
        return f;
    }
}

