/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import junit.framework.TestCase;
import org.apache.openjpa.kernel.QueryImpl;
import org.apache.openjpa.kernel.jpql.JPQLExpressionBuilder;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.simple.NamedEntity;

public class TestQueryCompilationCache
extends TestCase {
    public void testDynamicJPQLWithNamedEntity() {
        HashMap<Object, Object> props = new HashMap<Object, Object>(System.getProperties());
        props.put("openjpa.MetaDataFactory", "jpa(Types=" + NamedEntity.class.getName() + ")");
        OpenJPAEntityManagerFactorySPI emf = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.cast((EntityManagerFactory)Persistence.createEntityManagerFactory((String)"test", props));
        Map cache = emf.getConfiguration().getQueryCompilationCacheInstance();
        cache.clear();
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        OpenJPAQuery q = em.createQuery("select o from named o");
        q.compile();
        em.close();
        TestQueryCompilationCache.assertEquals((int)1, (int)cache.size());
        QueryImpl.Compilation comp = (QueryImpl.Compilation)cache.values().iterator().next();
        TestQueryCompilationCache.assertEquals(NamedEntity.class, (Object)((JPQLExpressionBuilder.ParsedJPQL)comp.storeData).getCandidateType());
        emf.close();
    }
}

