/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import org.apache.openjpa.event.AbstractLifecycleListener;
import org.apache.openjpa.event.AbstractTransactionListener;
import org.apache.openjpa.event.LifecycleEvent;
import org.apache.openjpa.event.TransactionEvent;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.simple.AllFieldTypes;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestBrokerFactoryListenerRegistry
extends SingleEMFTestCase {
    private int persistCount = 0;
    private int beginCount = 0;

    @Override
    public void setUp() {
        super.setUp(AllFieldTypes.class);
    }

    @Override
    protected OpenJPAEntityManagerFactorySPI createEMF(Object ... props) {
        OpenJPAEntityManagerFactorySPI emf = super.createEMF(props);
        emf.addLifecycleListener((Object)new AbstractLifecycleListener(){

            public void beforePersist(LifecycleEvent event) {
                TestBrokerFactoryListenerRegistry.this.persistCount++;
            }
        }, null);
        emf.addTransactionListener((Object)new AbstractTransactionListener(){

            public void afterBegin(TransactionEvent event) {
                TestBrokerFactoryListenerRegistry.this.beginCount++;
            }
        });
        return emf;
    }

    public void testLifecycleListenerRegistry() {
        this.beginCount = 0;
        this.persistCount = 0;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        try {
            em.persist((Object)new AllFieldTypes());
            em.flush();
            TestBrokerFactoryListenerRegistry.assertEquals((int)1, (int)this.beginCount);
            TestBrokerFactoryListenerRegistry.assertEquals((int)1, (int)this.persistCount);
        }
        finally {
            em.getTransaction().rollback();
            em.close();
        }
    }
}

