/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jta;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.openjpa.jta.SimpleTransaction;

public class SimpleTransactionManager
implements TransactionManager {
    private static ThreadLocal<SimpleTransaction> txns = new ThreadLocal();

    public void begin() throws NotSupportedException, SystemException {
        SimpleTransaction txn = this.getTransaction();
        int status = txn.getStatus();
        if (status != 3 && status != 4 && status != 5 && status != 0) {
            throw new IllegalStateException("Can not begin " + txn);
        }
        txn.setStatus(0);
    }

    public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
        this.assertActiveTransaction();
        try {
            this.getTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            txns.set(null);
        }
    }

    public int getStatus() throws SystemException {
        if (txns.get() == null) {
            return 6;
        }
        return this.getTransaction().getStatus();
    }

    public SimpleTransaction getTransaction() throws SystemException {
        SimpleTransaction txn = txns.get();
        if (txn == null) {
            txn = new SimpleTransaction();
            txn.setStatus(0);
            txns.set(txn);
        }
        return txn;
    }

    public void resume(Transaction arg0) throws IllegalStateException, InvalidTransactionException, SystemException {
        throw new UnsupportedOperationException();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.assertActiveTransaction();
        try {
            this.getTransaction().rollback();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            txns.set(null);
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.assertActiveTransaction();
        this.getTransaction().setRollbackOnly();
    }

    public void setTransactionTimeout(int arg0) throws SystemException {
        throw new UnsupportedOperationException();
    }

    public Transaction suspend() throws SystemException {
        throw new UnsupportedOperationException();
    }

    void assertActiveTransaction() throws IllegalStateException, SystemException {
        if (this.getStatus() == 6) {
            throw new IllegalStateException("No transaction on " + Thread.currentThread());
        }
    }
}

