/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jira2780;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Properties;
import java.util.Scanner;
import javax.persistence.Query;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.meta.ReverseMappingTool;
import org.apache.openjpa.jdbc.sql.DerbyDictionary;
import org.apache.openjpa.jira2780.Jira2780Enum;
import org.apache.openjpa.jira2780.Jira2780ReverseCustomizer;
import org.apache.openjpa.lib.util.Files;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestJira2780ReverseCustomizer
extends SingleEMFTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        File f = new File("target/orm.xml");
        if (f.exists()) {
            TestJira2780ReverseCustomizer.assertTrue((boolean)f.delete());
        }
        this.setSupportedDatabases(DerbyDictionary.class);
    }

    @Override
    public String getPersistenceUnitName() {
        return "rev-mapping-jira2780-pu";
    }

    public void testGettersAndSetters() throws Exception {
        JDBCConfiguration conf = (JDBCConfiguration)this.emf.getConfiguration();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Query q = em.createNativeQuery("CREATE TABLE JIRA2780.ABC (ID INTEGER PRIMARY KEY, TEST_ENUM VARCHAR(1))");
        try {
            q.executeUpdate();
            em.getTransaction().commit();
        }
        catch (Throwable t) {
            em.getTransaction().rollback();
            System.out.println(t.toString());
        }
        String clsName = "Abc";
        ReverseMappingTool.Flags flags = new ReverseMappingTool.Flags();
        flags.metaDataLevel = "none";
        flags.generateAnnotations = true;
        flags.packageName = ((Object)((Object)this)).getClass().getPackage().getName();
        flags.directory = Files.getFile((String)"./target", null);
        flags.customizer = new Jira2780ReverseCustomizer();
        Properties customProps = new Properties();
        customProps.put(flags.packageName + "." + "Abc" + ".testEnum.type", Jira2780Enum.class.getName());
        flags.customizer.setConfiguration(customProps);
        ReverseMappingTool.run((JDBCConfiguration)conf, (String[])new String[0], (ReverseMappingTool.Flags)flags, null);
        File abc = new File(Files.getPackageFile((File)flags.directory, (String)flags.packageName, (boolean)false), "Abc.java");
        String currLine = null;
        try (Scanner inFile = new Scanner(abc);){
            while (inFile.hasNextLine()) {
                String prevLine = currLine;
                currLine = inFile.nextLine();
                if (currLine.isEmpty() || !currLine.contains("Jira2780Enum testEnum")) continue;
                if (prevLine.contains("@Enumerated(EnumType.STRING)")) {
                    break;
                }
                TestJira2780ReverseCustomizer.fail((String)"@Enumerated annotation has not been injected");
            }
        }
        catch (FileNotFoundException e) {
            TestJira2780ReverseCustomizer.fail((String)"Abc.java not generated under ./target by ReverseMappingTool");
        }
        TestJira2780ReverseCustomizer.assertTrue((boolean)abc.delete());
    }
}

