/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.PersistenceProviderImpl;
import org.apache.openjpa.persistence.PersistenceUnitInfoImpl;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.StringId;
import org.junit.Assert;
import org.junit.Test;

public class TestSnakeCaseDDL {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void ddlInSnakeCase() throws SQLException {
        Driver derbyDriver;
        try {
            Class<?> derbyClazz = Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
            derbyDriver = (Driver)derbyClazz.newInstance();
        }
        catch (Exception e) {
            System.out.println("Skipping Derby specific test because Derby cannot be found in ClassPath");
            return;
        }
        PersistenceUnitInfoImpl persistenceUnitInfo = new PersistenceUnitInfoImpl();
        persistenceUnitInfo.setExcludeUnlistedClasses(true);
        persistenceUnitInfo.addManagedClassName(MyEntity1.class.getName());
        persistenceUnitInfo.addManagedClassName(MyEntity2.class.getName());
        BasicDataSource ds = new BasicDataSource();
        ds.setDriver(derbyDriver);
        ds.setUrl("jdbc:derby:memory:ddlInSnakeCase;create=true");
        persistenceUnitInfo.setJtaDataSource((DataSource)ds);
        persistenceUnitInfo.setProperty("openjpa.jdbc.DBDictionary", "derby(javaToDbColumnNameProcessing=snake_case)");
        new PersistenceProviderImpl().generateSchema((PersistenceUnitInfo)persistenceUnitInfo, new HashMap());
        HashSet<String> createdTables = new HashSet<String>();
        HashMap columns = new HashMap();
        try (Connection connection = ds.getConnection();){
            try (ResultSet tables = connection.getMetaData().getTables(null, null, "TestSnakeCaseDDL$MyEntity%", null);){
                while (tables.next()) {
                    String table = tables.getString(3);
                    createdTables.add(table);
                }
            }
            for (String table : createdTables) {
                Statement statement = connection.createStatement();
                Throwable throwable = null;
                try {
                    ResultSet rs = statement.executeQuery("select * from \"" + table + "\"");
                    Throwable throwable2 = null;
                    try {
                        ResultSetMetaData metaData = rs.getMetaData();
                        HashSet<String> columnNames = new HashSet<String>();
                        columns.put(table, columnNames);
                        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                            columnNames.add(metaData.getColumnName(i));
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (rs == null) continue;
                        if (throwable2 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        rs.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (statement == null) continue;
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    statement.close();
                }
            }
        }
        try (OpenJPAEntityManagerFactory entityManagerFactory = new PersistenceProviderImpl().createContainerEntityManagerFactory((PersistenceUnitInfo)persistenceUnitInfo, new HashMap());){
            em.getTransaction().begin();
            try (EntityManager em = entityManagerFactory.createEntityManager();){
                MyEntity1 entity = new MyEntity1();
                entity.setFooBar("1");
                entity.setThisField(123);
                em.persist((Object)entity);
                em.getTransaction().commit();
            }
            em = entityManagerFactory.createEntityManager();
            try {
                MyEntity1 myEntity1 = (MyEntity1)em.find(MyEntity1.class, (Object)"1");
                Assert.assertNotNull((Object)myEntity1);
                Assert.assertEquals((Object)"1", (Object)myEntity1.getFooBar());
                Assert.assertEquals((long)123L, (long)myEntity1.getThisField());
            }
            finally {
                em.close();
            }
            try (Connection connection = ds.getConnection();
                 Statement statement = connection.createStatement();
                 ResultSet rs = statement.executeQuery("select foo_bar, this_field from \"TestSnakeCaseDDL$MyEntity1\"");){
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"1", (Object)rs.getString(1));
                Assert.assertEquals((long)123L, (long)rs.getInt(2));
                Assert.assertFalse((boolean)rs.next());
            }
        }
        ds.close();
        Assert.assertEquals((long)2L, (long)((Collection)columns.get("TestSnakeCaseDDL$MyEntity1")).size());
        Assert.assertTrue((boolean)((Collection)columns.get("TestSnakeCaseDDL$MyEntity1")).contains("FOO_BAR"));
        Assert.assertTrue((boolean)((Collection)columns.get("TestSnakeCaseDDL$MyEntity1")).contains("THIS_FIELD"));
        Assert.assertEquals(Collections.singleton("ANOTHER_FIELD"), columns.get("TestSnakeCaseDDL$MyEntity2"));
    }

    @Entity
    public static class MyEntity2
    implements PersistenceCapable {
        @Id
        private String anotherField;
        private static int pcInheritedFieldCount;
        private static String[] pcFieldNames;
        private static Class[] pcFieldTypes;
        private static byte[] pcFieldFlags;
        private static Class pcPCSuperclass;
        protected transient StateManager pcStateManager;
        static /* synthetic */ Class class$Ljava$lang$String;
        static /* synthetic */ Class class$Lorg$apache$openjpa$jdbc$sql$TestSnakeCaseDDL$MyEntity2;
        private transient Object pcDetachedState;

        public int pcGetEnhancementContractVersion() {
            return 196634845;
        }

        static {
            pcFieldNames = new String[]{"anotherField"};
            Class[] classArray = new Class[1];
            Class clazz = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = MyEntity2.class$("java.lang.String"));
            classArray[0] = clazz;
            pcFieldTypes = classArray;
            pcFieldFlags = new byte[]{26};
            Class clazz2 = class$Lorg$apache$openjpa$jdbc$sql$TestSnakeCaseDDL$MyEntity2 != null ? class$Lorg$apache$openjpa$jdbc$sql$TestSnakeCaseDDL$MyEntity2 : (class$Lorg$apache$openjpa$jdbc$sql$TestSnakeCaseDDL$MyEntity2 = MyEntity2.class$("org.apache.openjpa.jdbc.sql.TestSnakeCaseDDL$MyEntity2"));
            PCRegistry.register((Class)clazz2, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"TestSnakeCaseDDL$MyEntity2", (PersistenceCapable)new MyEntity2());
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        protected void pcClearFields() {
            this.anotherField = null;
        }

        public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
            MyEntity2 myEntity2 = new MyEntity2();
            if (bl) {
                myEntity2.pcClearFields();
            }
            myEntity2.pcStateManager = stateManager;
            myEntity2.pcCopyKeyFieldsFromObjectId(object);
            return myEntity2;
        }

        public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
            MyEntity2 myEntity2 = new MyEntity2();
            if (bl) {
                myEntity2.pcClearFields();
            }
            myEntity2.pcStateManager = stateManager;
            return myEntity2;
        }

        protected static int pcGetManagedFieldCount() {
            return 1;
        }

        public void pcReplaceField(int n) {
            int n2 = n - pcInheritedFieldCount;
            if (n2 < 0) {
                throw new IllegalArgumentException();
            }
            switch (n2) {
                case 0: {
                    this.anotherField = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                    return;
                }
            }
            throw new IllegalArgumentException();
        }

        public void pcReplaceFields(int[] nArray) {
            int n = 0;
            while (n < nArray.length) {
                this.pcReplaceField(nArray[n]);
                ++n;
            }
        }

        public void pcProvideField(int n) {
            int n2 = n - pcInheritedFieldCount;
            if (n2 < 0) {
                throw new IllegalArgumentException();
            }
            switch (n2) {
                case 0: {
                    this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.anotherField);
                    return;
                }
            }
            throw new IllegalArgumentException();
        }

        public void pcProvideFields(int[] nArray) {
            int n = 0;
            while (n < nArray.length) {
                this.pcProvideField(nArray[n]);
                ++n;
            }
        }

        protected void pcCopyField(MyEntity2 myEntity2, int n) {
            int n2 = n - pcInheritedFieldCount;
            if (n2 < 0) {
                throw new IllegalArgumentException();
            }
            switch (n2) {
                case 0: {
                    this.anotherField = myEntity2.anotherField;
                    return;
                }
            }
            throw new IllegalArgumentException();
        }

        public void pcCopyFields(Object object, int[] nArray) {
            MyEntity2 myEntity2 = (MyEntity2)object;
            if (myEntity2.pcStateManager != this.pcStateManager) {
                throw new IllegalArgumentException();
            }
            if (this.pcStateManager == null) {
                throw new IllegalStateException();
            }
            int n = 0;
            while (n < nArray.length) {
                this.pcCopyField(myEntity2, nArray[n]);
                ++n;
            }
        }

        public Object pcGetGenericContext() {
            if (this.pcStateManager == null) {
                return null;
            }
            return this.pcStateManager.getGenericContext();
        }

        public Object pcFetchObjectId() {
            if (this.pcStateManager == null) {
                return null;
            }
            return this.pcStateManager.fetchObjectId();
        }

        public boolean pcIsDeleted() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.isDeleted();
        }

        public boolean pcIsDirty() {
            if (this.pcStateManager == null) {
                return false;
            }
            StateManager stateManager = this.pcStateManager;
            RedefinitionHelper.dirtyCheck((StateManager)stateManager);
            return stateManager.isDirty();
        }

        public boolean pcIsNew() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.isNew();
        }

        public boolean pcIsPersistent() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.isPersistent();
        }

        public boolean pcIsTransactional() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.isTransactional();
        }

        public boolean pcSerializing() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.serializing();
        }

        public void pcDirty(String string) {
            if (this.pcStateManager == null) {
                return;
            }
            this.pcStateManager.dirty(string);
        }

        public StateManager pcGetStateManager() {
            return this.pcStateManager;
        }

        public Object pcGetVersion() {
            if (this.pcStateManager == null) {
                return null;
            }
            return this.pcStateManager.getVersion();
        }

        public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
            if (this.pcStateManager != null) {
                this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
                return;
            }
            this.pcStateManager = stateManager;
        }

        public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
            throw new InternalException();
        }

        public void pcCopyKeyFieldsToObjectId(Object object) {
            throw new InternalException();
        }

        public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
            StringId stringId = (StringId)object;
            fieldConsumer.storeStringField(0 + pcInheritedFieldCount, stringId.getId());
        }

        public void pcCopyKeyFieldsFromObjectId(Object object) {
            StringId stringId = (StringId)object;
            this.anotherField = stringId.getId();
        }

        public Object pcNewObjectIdInstance(Object object) {
            Class clazz = class$Lorg$apache$openjpa$jdbc$sql$TestSnakeCaseDDL$MyEntity2 != null ? class$Lorg$apache$openjpa$jdbc$sql$TestSnakeCaseDDL$MyEntity2 : (class$Lorg$apache$openjpa$jdbc$sql$TestSnakeCaseDDL$MyEntity2 = MyEntity2.class$("org.apache.openjpa.jdbc.sql.TestSnakeCaseDDL$MyEntity2"));
            return new StringId(clazz, (String)object);
        }

        public Object pcNewObjectIdInstance() {
            Class clazz = class$Lorg$apache$openjpa$jdbc$sql$TestSnakeCaseDDL$MyEntity2 != null ? class$Lorg$apache$openjpa$jdbc$sql$TestSnakeCaseDDL$MyEntity2 : (class$Lorg$apache$openjpa$jdbc$sql$TestSnakeCaseDDL$MyEntity2 = MyEntity2.class$("org.apache.openjpa.jdbc.sql.TestSnakeCaseDDL$MyEntity2"));
            return new StringId(clazz, this.anotherField);
        }

        private static final String pcGetanotherField(MyEntity2 myEntity2) {
            if (myEntity2.pcStateManager == null) {
                return myEntity2.anotherField;
            }
            int n = pcInheritedFieldCount + 0;
            myEntity2.pcStateManager.accessingField(n);
            return myEntity2.anotherField;
        }

        private static final void pcSetanotherField(MyEntity2 myEntity2, String string) {
            if (myEntity2.pcStateManager == null) {
                myEntity2.anotherField = string;
                return;
            }
            myEntity2.pcStateManager.settingStringField((PersistenceCapable)myEntity2, pcInheritedFieldCount + 0, myEntity2.anotherField, string, 0);
        }

        public Boolean pcIsDetached() {
            if (this.pcStateManager != null) {
                if (this.pcStateManager.isDetached()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
                return Boolean.TRUE;
            }
            if (!this.pcisDetachedStateDefinitive()) {
                return null;
            }
            return Boolean.FALSE;
        }

        private boolean pcisDetachedStateDefinitive() {
            return false;
        }

        public Object pcGetDetachedState() {
            return this.pcDetachedState;
        }

        public void pcSetDetachedState(Object object) {
            this.pcDetachedState = object;
        }
    }

    @Entity
    public static class MyEntity1
    implements PersistenceCapable {
        @Id
        private String fooBar;
        private int thisField;
        private static int pcInheritedFieldCount;
        private static String[] pcFieldNames;
        private static Class[] pcFieldTypes;
        private static byte[] pcFieldFlags;
        private static Class pcPCSuperclass;
        protected transient StateManager pcStateManager;
        static /* synthetic */ Class class$Ljava$lang$String;
        static /* synthetic */ Class class$Lorg$apache$openjpa$jdbc$sql$TestSnakeCaseDDL$MyEntity1;
        private transient Object pcDetachedState;

        public int getThisField() {
            return MyEntity1.pcGetthisField(this);
        }

        public void setThisField(int thisField) {
            MyEntity1.pcSetthisField(this, thisField);
        }

        public String getFooBar() {
            return MyEntity1.pcGetfooBar(this);
        }

        public void setFooBar(String fooBar) {
            MyEntity1.pcSetfooBar(this, fooBar);
        }

        public int pcGetEnhancementContractVersion() {
            return 196634845;
        }

        static {
            pcFieldNames = new String[]{"fooBar", "thisField"};
            Class[] classArray = new Class[2];
            Class clazz = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = MyEntity1.class$("java.lang.String"));
            classArray[0] = clazz;
            classArray[1] = Integer.TYPE;
            pcFieldTypes = classArray;
            pcFieldFlags = new byte[]{26, 26};
            Class clazz2 = class$Lorg$apache$openjpa$jdbc$sql$TestSnakeCaseDDL$MyEntity1 != null ? class$Lorg$apache$openjpa$jdbc$sql$TestSnakeCaseDDL$MyEntity1 : (class$Lorg$apache$openjpa$jdbc$sql$TestSnakeCaseDDL$MyEntity1 = MyEntity1.class$("org.apache.openjpa.jdbc.sql.TestSnakeCaseDDL$MyEntity1"));
            PCRegistry.register((Class)clazz2, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"TestSnakeCaseDDL$MyEntity1", (PersistenceCapable)new MyEntity1());
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        protected void pcClearFields() {
            this.fooBar = null;
            this.thisField = 0;
        }

        public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
            MyEntity1 myEntity1 = new MyEntity1();
            if (bl) {
                myEntity1.pcClearFields();
            }
            myEntity1.pcStateManager = stateManager;
            myEntity1.pcCopyKeyFieldsFromObjectId(object);
            return myEntity1;
        }

        public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
            MyEntity1 myEntity1 = new MyEntity1();
            if (bl) {
                myEntity1.pcClearFields();
            }
            myEntity1.pcStateManager = stateManager;
            return myEntity1;
        }

        protected static int pcGetManagedFieldCount() {
            return 2;
        }

        public void pcReplaceField(int n) {
            int n2 = n - pcInheritedFieldCount;
            if (n2 < 0) {
                throw new IllegalArgumentException();
            }
            switch (n2) {
                case 0: {
                    this.fooBar = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                    return;
                }
                case 1: {
                    this.thisField = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                    return;
                }
            }
            throw new IllegalArgumentException();
        }

        public void pcReplaceFields(int[] nArray) {
            int n = 0;
            while (n < nArray.length) {
                this.pcReplaceField(nArray[n]);
                ++n;
            }
        }

        public void pcProvideField(int n) {
            int n2 = n - pcInheritedFieldCount;
            if (n2 < 0) {
                throw new IllegalArgumentException();
            }
            switch (n2) {
                case 0: {
                    this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.fooBar);
                    return;
                }
                case 1: {
                    this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.thisField);
                    return;
                }
            }
            throw new IllegalArgumentException();
        }

        public void pcProvideFields(int[] nArray) {
            int n = 0;
            while (n < nArray.length) {
                this.pcProvideField(nArray[n]);
                ++n;
            }
        }

        protected void pcCopyField(MyEntity1 myEntity1, int n) {
            int n2 = n - pcInheritedFieldCount;
            if (n2 < 0) {
                throw new IllegalArgumentException();
            }
            switch (n2) {
                case 0: {
                    this.fooBar = myEntity1.fooBar;
                    return;
                }
                case 1: {
                    this.thisField = myEntity1.thisField;
                    return;
                }
            }
            throw new IllegalArgumentException();
        }

        public void pcCopyFields(Object object, int[] nArray) {
            MyEntity1 myEntity1 = (MyEntity1)object;
            if (myEntity1.pcStateManager != this.pcStateManager) {
                throw new IllegalArgumentException();
            }
            if (this.pcStateManager == null) {
                throw new IllegalStateException();
            }
            int n = 0;
            while (n < nArray.length) {
                this.pcCopyField(myEntity1, nArray[n]);
                ++n;
            }
        }

        public Object pcGetGenericContext() {
            if (this.pcStateManager == null) {
                return null;
            }
            return this.pcStateManager.getGenericContext();
        }

        public Object pcFetchObjectId() {
            if (this.pcStateManager == null) {
                return null;
            }
            return this.pcStateManager.fetchObjectId();
        }

        public boolean pcIsDeleted() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.isDeleted();
        }

        public boolean pcIsDirty() {
            if (this.pcStateManager == null) {
                return false;
            }
            StateManager stateManager = this.pcStateManager;
            RedefinitionHelper.dirtyCheck((StateManager)stateManager);
            return stateManager.isDirty();
        }

        public boolean pcIsNew() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.isNew();
        }

        public boolean pcIsPersistent() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.isPersistent();
        }

        public boolean pcIsTransactional() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.isTransactional();
        }

        public boolean pcSerializing() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.serializing();
        }

        public void pcDirty(String string) {
            if (this.pcStateManager == null) {
                return;
            }
            this.pcStateManager.dirty(string);
        }

        public StateManager pcGetStateManager() {
            return this.pcStateManager;
        }

        public Object pcGetVersion() {
            if (this.pcStateManager == null) {
                return null;
            }
            return this.pcStateManager.getVersion();
        }

        public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
            if (this.pcStateManager != null) {
                this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
                return;
            }
            this.pcStateManager = stateManager;
        }

        public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
            throw new InternalException();
        }

        public void pcCopyKeyFieldsToObjectId(Object object) {
            throw new InternalException();
        }

        public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
            StringId stringId = (StringId)object;
            fieldConsumer.storeStringField(0 + pcInheritedFieldCount, stringId.getId());
        }

        public void pcCopyKeyFieldsFromObjectId(Object object) {
            StringId stringId = (StringId)object;
            this.fooBar = stringId.getId();
        }

        public Object pcNewObjectIdInstance(Object object) {
            Class clazz = class$Lorg$apache$openjpa$jdbc$sql$TestSnakeCaseDDL$MyEntity1 != null ? class$Lorg$apache$openjpa$jdbc$sql$TestSnakeCaseDDL$MyEntity1 : (class$Lorg$apache$openjpa$jdbc$sql$TestSnakeCaseDDL$MyEntity1 = MyEntity1.class$("org.apache.openjpa.jdbc.sql.TestSnakeCaseDDL$MyEntity1"));
            return new StringId(clazz, (String)object);
        }

        public Object pcNewObjectIdInstance() {
            Class clazz = class$Lorg$apache$openjpa$jdbc$sql$TestSnakeCaseDDL$MyEntity1 != null ? class$Lorg$apache$openjpa$jdbc$sql$TestSnakeCaseDDL$MyEntity1 : (class$Lorg$apache$openjpa$jdbc$sql$TestSnakeCaseDDL$MyEntity1 = MyEntity1.class$("org.apache.openjpa.jdbc.sql.TestSnakeCaseDDL$MyEntity1"));
            return new StringId(clazz, this.fooBar);
        }

        private static final String pcGetfooBar(MyEntity1 myEntity1) {
            if (myEntity1.pcStateManager == null) {
                return myEntity1.fooBar;
            }
            int n = pcInheritedFieldCount + 0;
            myEntity1.pcStateManager.accessingField(n);
            return myEntity1.fooBar;
        }

        private static final void pcSetfooBar(MyEntity1 myEntity1, String string) {
            if (myEntity1.pcStateManager == null) {
                myEntity1.fooBar = string;
                return;
            }
            myEntity1.pcStateManager.settingStringField((PersistenceCapable)myEntity1, pcInheritedFieldCount + 0, myEntity1.fooBar, string, 0);
        }

        private static final int pcGetthisField(MyEntity1 myEntity1) {
            if (myEntity1.pcStateManager == null) {
                return myEntity1.thisField;
            }
            int n = pcInheritedFieldCount + 1;
            myEntity1.pcStateManager.accessingField(n);
            return myEntity1.thisField;
        }

        private static final void pcSetthisField(MyEntity1 myEntity1, int n) {
            if (myEntity1.pcStateManager == null) {
                myEntity1.thisField = n;
                return;
            }
            myEntity1.pcStateManager.settingIntField((PersistenceCapable)myEntity1, pcInheritedFieldCount + 1, myEntity1.thisField, n, 0);
        }

        public Boolean pcIsDetached() {
            if (this.pcStateManager != null) {
                if (this.pcStateManager.isDetached()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
                return Boolean.TRUE;
            }
            if (!this.pcisDetachedStateDefinitive()) {
                return null;
            }
            return Boolean.FALSE;
        }

        private boolean pcisDetachedStateDefinitive() {
            return false;
        }

        public Object pcGetDetachedState() {
            return this.pcDetachedState;
        }

        public void pcSetDetachedState(Object object) {
            this.pcDetachedState = object;
        }
    }
}

