/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.procedure;

import java.util.Iterator;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.StoredProcedureQuery;
import org.apache.openjpa.jdbc.procedure.derby.Procedures;
import org.apache.openjpa.jdbc.procedure.entity.EntityWithStoredProcedure;
import org.apache.openjpa.jdbc.sql.DerbyDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.test.DatabasePlatform;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

@DatabasePlatform(value="org.apache.derby.jdbc.EmbeddedDriver")
public class TestStoredProcedure
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp("openjpa.RuntimeUnenhancedClasses", "unsupported", "openjpa.DynamicEnhancementAgent", "false", EntityWithStoredProcedure.class, EntityWithStoredProcedure.Mapping2.class);
        this.setSupportedDatabases(DerbyDictionary.class);
    }

    public void testSimple() throws Exception {
        Procedures.simpleCalled = false;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        this.exec((EntityManager)em, "DROP PROCEDURE TESTSIMPLE", true);
        this.exec((EntityManager)em, "CREATE PROCEDURE TESTSIMPLE() PARAMETER STYLE JAVA LANGUAGE JAVA EXTERNAL NAME '" + Procedures.class.getName() + ".simple'", false);
        StoredProcedureQuery procedure = em.createNamedStoredProcedureQuery("EntityWithStoredProcedure.simple");
        TestStoredProcedure.assertFalse((boolean)procedure.execute());
        em.close();
        TestStoredProcedure.assertTrue((boolean)Procedures.simpleCalled);
    }

    public void testInParams() throws Exception {
        Procedures.inParamsInteger = -1;
        Procedures.inParamsString = null;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        this.exec((EntityManager)em, "DROP PROCEDURE TESTINS", true);
        this.exec((EntityManager)em, "CREATE PROCEDURE TESTINS(SOME_NUMBER INTEGER,SOME_STRING VARCHAR(255)) PARAMETER STYLE JAVA LANGUAGE JAVA EXTERNAL NAME '" + Procedures.class.getName() + ".inParams'", false);
        StoredProcedureQuery procedure = em.createNamedStoredProcedureQuery("EntityWithStoredProcedure.inParams");
        procedure.setParameter("SOME_NUMBER", (Object)2015);
        procedure.setParameter("SOME_STRING", (Object)"openjpa");
        TestStoredProcedure.assertFalse((boolean)procedure.execute());
        TestStoredProcedure.assertEquals((int)2015, (int)Procedures.inParamsInteger);
        TestStoredProcedure.assertEquals((String)"openjpa", (String)Procedures.inParamsString);
        Procedures.inParamsInteger = -1;
        Procedures.inParamsString = null;
        StoredProcedureQuery procedure2 = em.createNamedStoredProcedureQuery("EntityWithStoredProcedure.inParams");
        procedure2.setParameter("SOME_NUMBER", (Object)20152);
        TestStoredProcedure.assertFalse((boolean)procedure2.execute());
        em.close();
        TestStoredProcedure.assertEquals((int)20152, (int)Procedures.inParamsInteger);
        TestStoredProcedure.assertNull((Object)Procedures.inParamsString);
    }

    public void testOut() throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        this.exec((EntityManager)em, "DROP PROCEDURE XTWO", true);
        this.exec((EntityManager)em, "CREATE PROCEDURE XTWO(IN SOME_NUMBER INTEGER,OUT x2 INTEGER) PARAMETER STYLE JAVA LANGUAGE JAVA EXTERNAL NAME '" + Procedures.class.getName() + ".x2'", false);
        StoredProcedureQuery procedure = em.createNamedStoredProcedureQuery("EntityWithStoredProcedure.x2");
        procedure.setParameter("SOME_NUMBER", (Object)5);
        TestStoredProcedure.assertFalse((boolean)procedure.execute());
        TestStoredProcedure.assertEquals((Object)10, (Object)procedure.getOutputParameterValue(2));
        em.close();
    }

    public void testInOut() throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        this.exec((EntityManager)em, "DROP PROCEDURE XINOUT", true);
        this.exec((EntityManager)em, "CREATE PROCEDURE XINOUT(INOUT P INTEGER) PARAMETER STYLE JAVA LANGUAGE JAVA EXTERNAL NAME '" + Procedures.class.getName() + ".inout'", false);
        StoredProcedureQuery procedure = em.createNamedStoredProcedureQuery("EntityWithStoredProcedure.inout");
        procedure.setParameter("P", (Object)5);
        TestStoredProcedure.assertFalse((boolean)procedure.execute());
        TestStoredProcedure.assertEquals((Object)10, (Object)procedure.getOutputParameterValue(1));
        em.close();
    }

    public void testMapping() throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        for (int i = 0; i < 2; ++i) {
            EntityWithStoredProcedure entity = new EntityWithStoredProcedure();
            entity.setId(1 + i);
            entity.setName("#" + entity.getId());
            em.persist((Object)entity);
        }
        em.getTransaction().commit();
        em.clear();
        this.exec((EntityManager)em, "DROP PROCEDURE MAPPING", true);
        this.exec((EntityManager)em, "CREATE PROCEDURE MAPPING() PARAMETER STYLE JAVA LANGUAGE JAVA DYNAMIC RESULT SETS 2 EXTERNAL NAME '" + Procedures.class.getName() + ".mapping'", false);
        StoredProcedureQuery procedure = em.createNamedStoredProcedureQuery("EntityWithStoredProcedure.mapping");
        TestStoredProcedure.assertTrue((boolean)procedure.execute());
        Iterator r1 = procedure.getResultList().iterator();
        EntityWithStoredProcedure next1 = (EntityWithStoredProcedure)EntityWithStoredProcedure.class.cast(r1.next());
        TestStoredProcedure.assertEquals((long)1L, (long)next1.getId());
        TestStoredProcedure.assertEquals((String)"#1", (String)next1.getName());
        TestStoredProcedure.assertNotNull((Object)next1);
        EntityWithStoredProcedure next2 = (EntityWithStoredProcedure)EntityWithStoredProcedure.class.cast(r1.next());
        TestStoredProcedure.assertNotNull((Object)next2);
        TestStoredProcedure.assertEquals((long)2L, (long)next2.getId());
        TestStoredProcedure.assertEquals((String)"#2", (String)next2.getName());
        TestStoredProcedure.assertFalse((boolean)r1.hasNext());
        TestStoredProcedure.assertTrue((boolean)procedure.hasMoreResults());
        Iterator r2 = procedure.getResultList().iterator();
        EntityWithStoredProcedure.Mapping2 next3 = (EntityWithStoredProcedure.Mapping2)EntityWithStoredProcedure.Mapping2.class.cast(r2.next());
        TestStoredProcedure.assertNotNull((Object)next3);
        TestStoredProcedure.assertFalse((boolean)r2.hasNext());
        TestStoredProcedure.assertEquals((long)next2.getId(), (long)next3.getId());
        TestStoredProcedure.assertEquals((String)next2.getName(), (String)next3.getName());
        em.getTransaction().begin();
        for (int i = 0; i < 2; ++i) {
            em.remove(em.find(EntityWithStoredProcedure.class, (Object)((long)i + 1L)));
        }
        em.getTransaction().commit();
        em.clear();
        em.close();
    }

    private void exec(EntityManager em, String proc, boolean ignoreExceptions) throws Exception {
        block4: {
            EntityTransaction tx = em.getTransaction();
            tx.begin();
            try {
                em.createNativeQuery(proc).executeUpdate();
                tx.commit();
            }
            catch (Exception sqe) {
                try {
                    tx.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (ignoreExceptions) break block4;
                throw sqe;
            }
        }
    }
}

