/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.oracle;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.persistence.EntityTransaction;
import javax.sql.DataSource;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.oracle.XmlColEntity;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.OracleDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.test.AbstractPersistenceTestCase;

public class TestOracleXmlColumn
extends AbstractPersistenceTestCase {
    private static String projectStr = "project";
    private static String xmlData = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><" + projectStr + " xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\"></" + projectStr + ">";

    private boolean skipTest(DBDictionary dict) {
        return !(dict instanceof OracleDictionary);
    }

    public void setUp() throws SQLException {
        OpenJPAEntityManagerFactorySPI emf = this.createEMF(new Object[0]);
        JDBCConfiguration conf = (JDBCConfiguration)emf.getConfiguration();
        DBDictionary dict = conf.getDBDictionaryInstance();
        if (this.skipTest(dict)) {
            emf.close();
            return;
        }
        Connection con = ((DataSource)conf.getConnectionFactory()).getConnection();
        con.setAutoCommit(true);
        Statement stmt = con.createStatement();
        String ddl = "DROP TABLE XmlColEntity";
        try {
            stmt.execute(ddl);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ddl = "CREATE TABLE XmlColEntity (ID NUMBER NOT NULL, XMLCOLUMN " + dict.xmlTypeName + ", VERSION NUMBER, PRIMARY KEY (ID))";
        stmt.execute(ddl);
        String insertSql = "INSERT into XmlColEntity (ID, XMLCOLUMN, VERSION) VALUES (42, '" + xmlData + "', 1)";
        stmt.execute(insertSql);
        stmt.close();
        con.close();
        emf.close();
    }

    public void testCrudXmlColumn() throws SQLException {
        OpenJPAEntityManagerFactorySPI emf = this.createEMF(XmlColEntity.class, "openjpa.jdbc.SchemaFactory", "native", "openjpa.jdbc.SynchronizeMappings", "");
        JDBCConfiguration conf = (JDBCConfiguration)emf.getConfiguration();
        DBDictionary dict = conf.getDBDictionaryInstance();
        if (this.skipTest(dict)) {
            emf.close();
            return;
        }
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        XmlColEntity xce = new XmlColEntity();
        xce.setId(1);
        xce.setXmlColumn(xmlData);
        tran.begin();
        em.persist((Object)xce);
        tran.commit();
        em.close();
        em = emf.createEntityManager();
        xce = (XmlColEntity)em.find(XmlColEntity.class, (Object)1);
        TestOracleXmlColumn.assertNotNull((Object)xce);
        TestOracleXmlColumn.assertEquals((String)xmlData, (String)this.xmlResult(xce.getXmlColumn()));
        em.close();
        emf.close();
    }

    public void testExistingColumn() throws SQLException {
        OpenJPAEntityManagerFactorySPI emf = this.createEMF(XmlColEntity.class, "openjpa.jdbc.SchemaFactory", "native", "openjpa.jdbc.SynchronizeMappings", "");
        JDBCConfiguration conf = (JDBCConfiguration)emf.getConfiguration();
        DBDictionary dict = conf.getDBDictionaryInstance();
        if (this.skipTest(dict)) {
            emf.close();
            return;
        }
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        XmlColEntity xce = (XmlColEntity)em.find(XmlColEntity.class, (Object)42);
        TestOracleXmlColumn.assertNotNull((Object)xce);
        TestOracleXmlColumn.assertNotNull((Object)xce.getXmlColumn());
        TestOracleXmlColumn.assertEquals((String)xmlData, (String)this.xmlResult(xce.getXmlColumn()));
        em.close();
        emf.close();
    }

    private String xmlResult(String xml) {
        xml = xml.replace("\r", "").replace("\n", "").replace("/>", "></" + projectStr + ">").trim();
        return xml;
    }
}

