/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta;

import java.io.StringWriter;
import java.net.URL;
import java.util.Map;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.meta.EntityBoolChar;
import org.apache.openjpa.jdbc.meta.MappingTool;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.test.AbstractPersistenceTestCase;
import org.junit.Test;

public class TestMappingToolRefresh
extends AbstractPersistenceTestCase {
    @Test
    public void testSchemaCreation() throws Exception {
        Map<String, Object> emfProps = this.getPropertiesMap(EntityBoolChar.class, "openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true, SchemaAction='add,deleteTableContents')", "openjpa.jdbc.DBDictionary", "(BitTypeName=CHAR(1),BooleanTypeName=CHAR(1),BooleanRepresentation=STRING_10)");
        OpenJPAEntityManagerFactorySPI openjpaEmf = this.createNamedOpenJPAEMF("test", null, emfProps);
        OpenJPAEntityManagerSPI em = openjpaEmf.createEntityManager();
        TestMappingToolRefresh.assertNotNull((Object)em);
        em.getTransaction().begin();
        EntityBoolChar val = new EntityBoolChar();
        val.setDummy(true);
        em.persist((Object)val);
        em.getTransaction().commit();
        int id = val.getId();
        em.close();
        OpenJPAEntityManagerSPI em2 = openjpaEmf.createEntityManager();
        TestMappingToolRefresh.assertNotNull((Object)em2);
        EntityBoolChar val2 = (EntityBoolChar)em2.find(EntityBoolChar.class, (Object)id);
        TestMappingToolRefresh.assertNotNull((Object)val2);
        TestMappingToolRefresh.assertNotEquals(val, val2);
        openjpaEmf.close();
        openjpaEmf = this.createNamedOpenJPAEMF("test", null, emfProps);
        String metaDataFactory = openjpaEmf.getConfiguration().getMetaDataFactory();
        JDBCConfigurationImpl jdbcConf = new JDBCConfigurationImpl();
        jdbcConf.setMetaDataFactory(metaDataFactory);
        String[] entityClassFiles = new String[1];
        URL entityClassUrl = ((Object)((Object)this)).getClass().getClassLoader().getResource(EntityBoolChar.class.getName().replace(".", "/") + ".class");
        entityClassFiles[0] = entityClassUrl.getFile();
        MappingTool.Flags flags = new MappingTool.Flags();
        flags.mappingWriter = new StringWriter();
        flags.action = "refresh";
        flags.schemaAction = "refresh";
        flags.sqlWriter = new StringWriter();
        flags.schemaWriter = new StringWriter();
        boolean ok = MappingTool.run((JDBCConfiguration)jdbcConf, (String[])entityClassFiles, (MappingTool.Flags)flags, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        TestMappingToolRefresh.assertTrue((boolean)ok);
        TestMappingToolRefresh.assertTrue((boolean)flags.sqlWriter.toString().isEmpty());
    }
}

