/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.jdbc.kernel.JDBCStoreManager;
import org.apache.openjpa.jdbc.kernel.OptSelectEntity;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.kernel.StoreManager;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.persistence.EntityManagerImpl;
import org.apache.openjpa.persistence.FetchPlan;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.JDBCFetchPlan;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestJDBCStoreOptSelect
extends SQLListenerTestCase {
    Object[] props = new Object[]{CLEAR_TABLES, OptSelectEntity.class};
    OptSelectEntity e1;
    OptSelectEntity e2;

    @Override
    public void setUp() throws Exception {
        super.setUp(this.props);
        this.createData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        StoreManager store = ((EntityManagerImpl)em).getBroker().getStoreManager().getDelegate();
        FetchPlan fp = this.getFetchPlan(em);
        try {
            this.sql.clear();
            if (!(store instanceof JDBCStoreManager)) {
                TestJDBCStoreOptSelect.fail((String)"StoreManager is not an instanceof JDBCStoreManager");
            }
            ((JDBCFetchPlan)fp).setIgnoreDfgForFkSelect(true);
            fp.removeField(OptSelectEntity.class, "eagerOneToOne");
            fp.removeField(OptSelectEntity.class, "eagerOneToOneOwner");
            fp.removeField(OptSelectEntity.class, "lazyOneToOne");
            fp.removeField(OptSelectEntity.class, "lazyOneToOneOwner");
            OptSelectEntity ee1 = (OptSelectEntity)em.find(OptSelectEntity.class, (Object)this.e1.getId());
            TestJDBCStoreOptSelect.assertEquals((int)1, (int)this.sql.size());
            String s = (String)this.sql.get(0);
            TestJDBCStoreOptSelect.assertFalse((s.contains("JOIN") && s.contains("join") ? 1 : 0) != 0);
            StateManagerImpl smi = (StateManagerImpl)((PersistenceCapable)ee1).pcGetStateManager();
            ClassMetaData cmd = em.getConfiguration().getMetaDataRepositoryInstance().getMetaData(OptSelectEntity.class, null, true);
            int fks = 0;
            for (FieldMetaData fmd : cmd.getFields()) {
                if (smi.getIntermediate(fmd.getIndex()) == null) continue;
                ++fks;
            }
            TestJDBCStoreOptSelect.assertEquals((int)2, (int)fks);
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            if (em.isOpen()) {
                em.close();
            }
        }
    }

    private FetchPlan getFetchPlan(OpenJPAEntityManagerSPI em) {
        MetaDataRepository mdr = em.getConfiguration().getMetaDataRepositoryInstance();
        FetchPlan fp = em.pushFetchPlan();
        fp.removeFetchGroups(fp.getFetchGroups());
        for (Class cls : new Class[]{OptSelectEntity.class}) {
            ClassMetaData cmd = mdr.getMetaData(cls, null, true);
            for (FieldMetaData fmd : cmd.getFields()) {
                fp.addField(cls, fmd.getName());
            }
        }
        return fp;
    }

    void createData() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            em.getTransaction().begin();
            this.e1 = new OptSelectEntity();
            this.e2 = new OptSelectEntity();
            this.e1.setEagerOneToOne(this.e2);
            this.e2.setEagerOneToOneOwner(this.e2);
            this.e1.setLazyOneToOne(this.e2);
            this.e2.setLazyOneToOneOwner(this.e1);
            em.persistAll(new Object[]{this.e1, this.e2});
            em.getTransaction().commit();
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            if (em.isOpen()) {
                em.close();
            }
        }
    }
}

