/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.instrumentation;

import java.util.Random;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.instrumentation.BrokerLevelInstrument;
import org.apache.openjpa.instrumentation.CacheableEntity;
import org.apache.openjpa.instrumentation.DataCacheInstrument;
import org.apache.openjpa.instrumentation.DynamicProvider;
import org.apache.openjpa.instrumentation.InstrumentationManager;
import org.apache.openjpa.instrumentation.PreparedQueryCacheInstrument;
import org.apache.openjpa.instrumentation.QueryCacheInstrument;
import org.apache.openjpa.instrumentation.SecondProvider;
import org.apache.openjpa.instrumentation.SimpleProvider;
import org.apache.openjpa.lib.instrumentation.Instrument;
import org.apache.openjpa.lib.instrumentation.InstrumentationProvider;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestInstrumentationProvider
extends SingleEMFTestCase {
    public static final String SINGLE_PROVIDER = "org.apache.openjpa.instrumentation.SimpleProvider(Instrument='DataCache,QueryCache,QuerySQLCache')";
    public static final String MULTI_PROVIDER = "org.apache.openjpa.instrumentation.SimpleProvider(Instrument='DataCache,QueryCache,QuerySQLCache'), org.apache.openjpa.instrumentation.SecondProvider(Instrument='DataCache,QuerySQLCache')";
    public static final String DC_PROVIDER = "org.apache.openjpa.instrumentation.SimpleProvider(Instrument='DataCache')";

    @Override
    public void setUp() throws Exception {
        super.setUp("openjpa.Instrumentation", SINGLE_PROVIDER, "openjpa.DataCache", "true(EnableStatistics=true)", "openjpa.QueryCache", "true", "openjpa.RemoteCommitProvider", "sjvm");
    }

    public void testProviderConfig() {
        TestInstrumentationProvider.assertNotNull((Object)this.emf);
        String instrValue = this.emf.getConfiguration().getInstrumentation();
        TestInstrumentationProvider.assertEquals((String)instrValue, (String)SINGLE_PROVIDER);
        InstrumentationManager mgr = this.emf.getConfiguration().getInstrumentationManagerInstance();
        TestInstrumentationProvider.assertNotNull((Object)mgr);
        Set providers = mgr.getProviders();
        TestInstrumentationProvider.assertNotNull((Object)providers);
        TestInstrumentationProvider.assertEquals((int)1, (int)providers.size());
        InstrumentationProvider provider = (InstrumentationProvider)providers.iterator().next();
        TestInstrumentationProvider.assertEquals(provider.getClass(), SimpleProvider.class);
        Set instruments = provider.getInstruments();
        TestInstrumentationProvider.assertNotNull((Object)instruments);
        TestInstrumentationProvider.assertEquals((int)3, (int)instruments.size());
        Instrument inst = provider.getInstrumentByName("SimpleDCInstrument");
        TestInstrumentationProvider.assertNotNull((Object)inst);
        TestInstrumentationProvider.assertTrue((boolean)(inst instanceof DataCacheInstrument));
        DataCacheInstrument dci = (DataCacheInstrument)inst;
        TestInstrumentationProvider.assertEquals((String)dci.getCacheName(), (String)"default");
        inst = provider.getInstrumentByName("SimpleQCInstrument");
        TestInstrumentationProvider.assertNotNull((Object)inst);
        TestInstrumentationProvider.assertTrue((boolean)(inst instanceof QueryCacheInstrument));
        inst = provider.getInstrumentByName("SimpleQSCInstrument");
        TestInstrumentationProvider.assertNotNull((Object)inst);
        TestInstrumentationProvider.assertTrue((boolean)(inst instanceof PreparedQueryCacheInstrument));
    }

    public void testDynamicInstrumentConfig() {
        InstrumentationManager mgr = this.emf.getConfiguration().getInstrumentationManagerInstance();
        TestInstrumentationProvider.assertNotNull((Object)mgr);
        Set providers = mgr.getProviders();
        TestInstrumentationProvider.assertNotNull((Object)providers);
        TestInstrumentationProvider.assertEquals((int)1, (int)providers.size());
        InstrumentationProvider provider = (InstrumentationProvider)providers.iterator().next();
        TestInstrumentationProvider.assertEquals(provider.getClass(), SimpleProvider.class);
        this.verifyBrokerLevelInstrument(provider);
    }

    public void testDynamicProviderConfig() {
        InstrumentationManager mgr = this.emf.getConfiguration().getInstrumentationManagerInstance();
        TestInstrumentationProvider.assertNotNull((Object)mgr);
        DynamicProvider dyp = new DynamicProvider();
        mgr.manageProvider((InstrumentationProvider)dyp);
        this.verifyBrokerLevelInstrument((InstrumentationProvider)dyp);
        TestInstrumentationProvider.assertTrue((boolean)dyp.isStarted());
        TestInstrumentationProvider.assertNotNull((Object)dyp.getInstrumentByName(BrokerLevelInstrument.NAME));
        TestInstrumentationProvider.assertEquals((int)2, (int)mgr.getProviders().size());
    }

    public void verifyBrokerLevelInstrument(InstrumentationProvider provider) {
        BrokerLevelInstrument bli = new BrokerLevelInstrument();
        provider.addInstrument((Instrument)bli);
        TestInstrumentationProvider.assertFalse((boolean)bli.isInitialized());
        TestInstrumentationProvider.assertFalse((boolean)bli.isStarted());
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        TestInstrumentationProvider.assertTrue((boolean)bli.isInitialized());
        TestInstrumentationProvider.assertTrue((boolean)bli.isStarted());
        em.close();
        TestInstrumentationProvider.assertFalse((boolean)bli.isStarted());
    }

    public void testDataCacheInstrument() {
        OpenJPAEntityManagerFactorySPI oemf = this.createEMF("openjpa.Instrumentation", DC_PROVIDER, "openjpa.DataCache", "true(EnableStatistics=true)", "openjpa.RemoteCommitProvider", "sjvm", "openjpa.jdbc.SynchronizeMappings", "buildSchema", CacheableEntity.class);
        TestInstrumentationProvider.assertNotNull((Object)oemf);
        String instrValue = oemf.getConfiguration().getInstrumentation();
        TestInstrumentationProvider.assertEquals((String)DC_PROVIDER, (String)instrValue);
        InstrumentationManager mgr = oemf.getConfiguration().getInstrumentationManagerInstance();
        TestInstrumentationProvider.assertNotNull((Object)mgr);
        Set providers = mgr.getProviders();
        TestInstrumentationProvider.assertNotNull((Object)providers);
        TestInstrumentationProvider.assertEquals((int)1, (int)providers.size());
        InstrumentationProvider provider = (InstrumentationProvider)providers.iterator().next();
        TestInstrumentationProvider.assertEquals(provider.getClass(), SimpleProvider.class);
        Instrument inst = provider.getInstrumentByName("SimpleDCInstrument");
        TestInstrumentationProvider.assertNotNull((Object)inst);
        TestInstrumentationProvider.assertTrue((boolean)(inst instanceof DataCacheInstrument));
        DataCacheInstrument dci = (DataCacheInstrument)inst;
        TestInstrumentationProvider.assertEquals((String)dci.getCacheName(), (String)"default");
        OpenJPAEntityManagerSPI oem = oemf.createEntityManager();
        CacheableEntity ce = new CacheableEntity();
        int id = new Random().nextInt();
        ce.setId(id);
        oem.getTransaction().begin();
        oem.persist((Object)ce);
        oem.getTransaction().commit();
        oem.clear();
        TestInstrumentationProvider.assertTrue((boolean)oemf.getCache().contains(CacheableEntity.class, (Object)id));
        ce = (CacheableEntity)oem.find(CacheableEntity.class, (Object)id);
        TestInstrumentationProvider.assertTrue((dci.getHitCount() > 0L ? 1 : 0) != 0);
        TestInstrumentationProvider.assertTrue((dci.getReadCount() > 0L ? 1 : 0) != 0);
        TestInstrumentationProvider.assertTrue((dci.getWriteCount() > 0L ? 1 : 0) != 0);
        TestInstrumentationProvider.assertTrue((dci.getHitCount(CacheableEntity.class.getName()) > 0L ? 1 : 0) != 0);
        TestInstrumentationProvider.assertTrue((dci.getReadCount(CacheableEntity.class.getName()) > 0L ? 1 : 0) != 0);
        TestInstrumentationProvider.assertTrue((dci.getWriteCount(CacheableEntity.class.getName()) > 0L ? 1 : 0) != 0);
        this.closeEMF((EntityManagerFactory)oemf);
    }

    public void testMultipleProviderConfig() {
        OpenJPAEntityManagerFactorySPI oemf = this.createEMF("openjpa.Instrumentation", MULTI_PROVIDER, "openjpa.DataCache", "true(EnableStatistics=true)", "openjpa.QueryCache", "true", "openjpa.RemoteCommitProvider", "sjvm");
        TestInstrumentationProvider.assertNotNull((Object)oemf);
        String instrValue = oemf.getConfiguration().getInstrumentation();
        TestInstrumentationProvider.assertEquals((String)MULTI_PROVIDER, (String)instrValue);
        InstrumentationManager mgr = oemf.getConfiguration().getInstrumentationManagerInstance();
        TestInstrumentationProvider.assertNotNull((Object)mgr);
        Set providers = mgr.getProviders();
        TestInstrumentationProvider.assertNotNull((Object)providers);
        TestInstrumentationProvider.assertEquals((int)2, (int)providers.size());
        for (InstrumentationProvider provider : providers) {
            TestInstrumentationProvider.assertTrue((provider instanceof SimpleProvider || provider instanceof SecondProvider ? 1 : 0) != 0);
            if (provider instanceof SimpleProvider) {
                TestInstrumentationProvider.assertEquals((int)3, (int)provider.getInstruments().size());
                continue;
            }
            TestInstrumentationProvider.assertEquals((int)2, (int)provider.getInstruments().size());
        }
        this.closeEMF((EntityManagerFactory)oemf);
    }
}

