/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.event;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.openjpa.event.RemoteCommitEvent;
import org.apache.openjpa.event.RemoteCommitListener;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.test.AbstractCachedEMFTestCase;

public class TestSJVMRemoteCommitProvider
extends AbstractCachedEMFTestCase {
    private OpenJPAEntityManagerFactorySPI emf1;
    private OpenJPAEntityManagerFactorySPI emf2;
    private ListenerImpl listen1;
    private ListenerImpl listen2;

    public void setUp() {
        HashMap<String, String> sjvm1 = new HashMap<String, String>();
        sjvm1.put("openjpa.RemoteCommitProvider", "sjvm");
        sjvm1.put("openjpa.DetachState", "true");
        this.emf1 = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.cast((EntityManagerFactory)Persistence.createEntityManagerFactory((String)"test", sjvm1));
        this.listen1 = new ListenerImpl();
        this.emf1.getConfiguration().getRemoteCommitEventManager().addListener((RemoteCommitListener)this.listen1);
        HashMap<String, String> sjvm2 = new HashMap<String, String>();
        sjvm2.put("openjpa.RemoteCommitProvider", "sjvm");
        sjvm2.put("openjpa.DetachState", "false");
        this.emf2 = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.cast((EntityManagerFactory)Persistence.createEntityManagerFactory((String)"test", sjvm2));
        this.listen2 = new ListenerImpl();
        this.emf2.getConfiguration().getRemoteCommitEventManager().addListener((RemoteCommitListener)this.listen2);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.clear((EntityManagerFactory)this.emf1);
        this.closeEMF((EntityManagerFactory)this.emf1);
        this.clear((EntityManagerFactory)this.emf2);
        this.closeEMF((EntityManagerFactory)this.emf2);
    }

    public void testSJVMRemoteCommitProvider() {
        TestSJVMRemoteCommitProvider.assertNotSame((Object)JPAFacadeHelper.toBrokerFactory((EntityManagerFactory)this.emf1), (Object)JPAFacadeHelper.toBrokerFactory((EntityManagerFactory)this.emf2));
        this.emf1.getConfiguration().getRemoteCommitEventManager().getRemoteCommitProvider().broadcast(new RemoteCommitEvent(0, (Collection)Collections.EMPTY_SET, (Collection)Collections.EMPTY_SET, (Collection)Collections.EMPTY_SET, (Collection)Collections.EMPTY_SET));
        TestSJVMRemoteCommitProvider.assertEquals((int)0, (int)this.listen1.eventCount);
        TestSJVMRemoteCommitProvider.assertEquals((int)1, (int)this.listen2.eventCount);
    }

    private class ListenerImpl
    implements RemoteCommitListener {
        private int eventCount;

        private ListenerImpl() {
        }

        public void afterCommit(RemoteCommitEvent event) {
            ++this.eventCount;
        }

        public void close() {
        }
    }
}

