/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.conf;

import org.apache.openjpa.conf.CacheMarshaller;
import org.apache.openjpa.conf.CacheMarshallerImpl;
import org.apache.openjpa.conf.CacheMarshallersValue;
import org.apache.openjpa.conf.OpenJPAVersion;
import org.apache.openjpa.conf.OpenJPAVersionAndConfigurationTypeValidationPolicy;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestCacheMarshaller
extends SingleEMFTestCase {
    private CacheMarshaller cm;

    @Override
    public void setUp() {
        this.setUp("openjpa.CacheMarshallers", "default(Id=" + ((Object)((Object)this)).getClass().getName() + ", ValidationPolicy=" + OpenJPAVersionAndConfigurationTypeValidationPolicy.class.getName() + ", InputURL=file:target/test-classes/" + ((Object)((Object)this)).getClass().getName() + ".ser, OutputFile=target/test-classes/" + ((Object)((Object)this)).getClass().getName() + ".ser)");
        this.emf.createEntityManager().close();
        this.cm = CacheMarshallersValue.getMarshallerById((Configuration)this.emf.getConfiguration(), (String)((Object)((Object)this)).getClass().getName());
    }

    public void testCacheMarshallerType() {
        TestCacheMarshaller.assertEquals(CacheMarshallerImpl.class, this.cm.getClass());
    }

    public void testConfiguration() {
        TestCacheMarshaller.assertEquals((String)((Object)((Object)this)).getClass().getName(), (String)this.cm.getId());
    }

    public void testValidation() {
        CacheMarshaller.ValidationPolicy vp = ((CacheMarshallerImpl)this.cm).getValidationPolicy();
        TestCacheMarshaller.assertEquals(OpenJPAVersionAndConfigurationTypeValidationPolicy.class, vp.getClass());
        Object[] cached = (Object[])vp.getCacheableData((Object)this);
        TestCacheMarshaller.assertEquals((int)3, (int)cached.length);
        TestCacheMarshaller.assertEquals((Object)OpenJPAVersion.VERSION_ID, (Object)cached[0]);
        TestCacheMarshaller.assertEquals((Object)this.emf.getConfiguration().getClass().getName(), (Object)cached[1]);
        TestCacheMarshaller.assertEquals((Object)((Object)this), (Object)cached[2]);
        TestCacheMarshaller.assertEquals((Object)((Object)this), (Object)vp.getValidData((Object)cached));
    }

    public void testRoundTrip() {
        String o = "foo";
        this.cm.store((Object)o);
        TestCacheMarshaller.assertEquals((Object)o, (Object)this.cm.load());
    }

    public void testendConfiguration() {
        ((CacheMarshallerImpl)this.cm).setInputURL(null);
        ((CacheMarshallerImpl)this.cm).setInputResource(((Object)((Object)this)).getClass().getName() + ".ser");
        ((CacheMarshallerImpl)this.cm).endConfiguration();
    }
}

