/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.conf;

import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceException;
import junit.framework.TestCase;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.util.UserException;

public class TestBadJdbcUrl
extends TestCase {
    public static final String GOOD_URL = "jdbc:derby:target/database/openjpa-derby-database;create=true";
    public static final String GOOD_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    public static final String GOOD_DATASOURCE = "org.apache.commons.dbcp2.BasicDataSource";
    public static final String BAD_DRIVER = "bad.driver";
    public static final String BAD_URL_PROTOCOL = "bad.url.protocol";
    public static final String BAD_URL_SUBPROTOCOL = "bad.url.sub.protocol";
    public static final String BAD_CONN_PROPS = "connectionUrl=bad,connectionDriver=bad";

    public void testBadUrlProtocolValueWithValidDriverClass() {
        Properties p = new Properties();
        p.put("openjpa.ConnectionDriverName", GOOD_DRIVER);
        p.put("openjpa.ConnectionURL", BAD_URL_PROTOCOL);
        this.verifyConnectException(p, PersistenceException.class, UserException.class, GOOD_DRIVER, BAD_URL_PROTOCOL);
    }

    public void testBadUrlProtocolValueWithValidDataSource() {
        Properties p = new Properties();
        p.put("openjpa.ConnectionDriverName", GOOD_DATASOURCE);
        p.put("openjpa.ConnectionURL", BAD_URL_PROTOCOL);
        p.put("openjpa.ConnectionProperties", BAD_CONN_PROPS);
        this.verifyConnectException(p, PersistenceException.class, null, null);
    }

    public void testBadUrlSubprotocolValueWithValidDriverClass() {
        Properties p = new Properties();
        p.put("openjpa.ConnectionDriverName", GOOD_DRIVER);
        p.put("openjpa.ConnectionURL", BAD_URL_SUBPROTOCOL);
        this.verifyConnectException(p, PersistenceException.class, UserException.class, GOOD_DRIVER, BAD_URL_SUBPROTOCOL);
    }

    public void testBadUrlSubprotocolValueWithValidDataSource() {
        Properties p = new Properties();
        p.put("openjpa.ConnectionDriverName", GOOD_DRIVER);
        p.put("openjpa.ConnectionURL", BAD_URL_SUBPROTOCOL);
        this.verifyConnectException(p, PersistenceException.class, UserException.class, GOOD_DRIVER, BAD_URL_SUBPROTOCOL);
    }

    public void testValidUrlWithInvalidDriver() {
        Properties p = new Properties();
        p.put("openjpa.ConnectionDriverName", BAD_DRIVER);
        p.put("openjpa.ConnectionURL", GOOD_URL);
        this.verifyConnectException(p, PersistenceException.class, UserException.class, GOOD_URL, BAD_DRIVER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyConnectException(Properties props, Class targetType, Class nestedType, String ... keys) {
        EntityManagerFactory emf = null;
        EntityManager em = null;
        try {
            emf = Persistence.createEntityManagerFactory((String)"test", (Map)props);
            em = emf.createEntityManager();
            OpenJPAPersistence.cast((EntityManager)em).getConnection();
            TestBadJdbcUrl.fail((String)("Should have caught a " + targetType.getName()));
        }
        catch (Throwable t) {
            this.assertException(t, targetType, nestedType);
            this.assertMessage(t, keys);
        }
        finally {
            if (em != null) {
                em.close();
            }
            if (emf != null) {
                emf.close();
            }
        }
    }

    void assertException(Throwable actual, Class targetType, Class nestedTargetType) {
        if (targetType == null) {
            return;
        }
        TestBadJdbcUrl.assertNotNull((Object)actual);
        Class<?> actualType = actual.getClass();
        if (!targetType.isAssignableFrom(actualType)) {
            TestBadJdbcUrl.fail((String)(targetType.getName() + " is not assignable from " + actualType.getName()));
        }
        if (nestedTargetType != null) {
            Class<?> nestedType;
            Throwable nested = actual.getCause();
            Class<?> clazz = nestedType = nested == null ? null : nested.getClass();
            while (nestedType != null) {
                if (nestedType.isAssignableFrom(nestedTargetType)) {
                    return;
                }
                Throwable next = nested.getCause();
                if (next == null || next == nested) break;
                nestedType = next.getClass();
                nested = next;
            }
            TestBadJdbcUrl.fail((String)("No nested type " + nestedTargetType + " in " + actual));
        }
    }

    void assertMessage(Throwable actual, String ... keys) {
        if (actual == null || keys == null) {
            return;
        }
        String message = actual.getMessage();
        for (String key : keys) {
            TestBadJdbcUrl.assertTrue((String)(key + " is not in " + message), (boolean)message.contains(key));
        }
    }
}

