/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.audit;

import java.util.Collection;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.audit.AuditedEntry;
import org.apache.openjpa.audit.Auditor;
import org.apache.openjpa.audit.X;
import org.apache.openjpa.ee.ManagedRuntime;
import org.apache.openjpa.kernel.Audited;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestBeginEventOnTransactionListener
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(X.class, AuditedEntry.class, CLEAR_TABLES);
    }

    @Override
    protected String getPersistenceUnitName() {
        return "auditjta";
    }

    public void test() throws Exception {
        this.doTest((EntityManagerFactory)this.emf);
        TestBeginEventOnTransactionListener.assertTrue((boolean)MockAuditor.called);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTest(EntityManagerFactory emf) throws Exception {
        ManagedRuntime runtime = ((OpenJPAEntityManagerFactorySPI)OpenJPAEntityManagerFactorySPI.class.cast(emf)).getConfiguration().getManagedRuntimeInstance();
        runtime.getTransactionManager().begin();
        try {
            EntityManager em = emf.createEntityManager();
            em.joinTransaction();
            X x = new X();
            em.persist((Object)x);
            runtime.getTransactionManager().commit();
        }
        finally {
            emf.close();
        }
    }

    public static class MockAuditor
    implements Auditor {
        public static boolean called = false;

        public void audit(Broker broker, Collection<Audited> newObjects, Collection<Audited> updates, Collection<Audited> deletes) {
            called = true;
        }

        public boolean isRollbackOnError() {
            return false;
        }

        public void close() throws Exception {
        }

        public void setConfiguration(Configuration conf) {
        }

        public void startConfiguration() {
        }

        public void endConfiguration() {
        }
    }
}

