/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.audit;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.openjpa.audit.AuditableOperation;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.kernel.Audited;
import org.apache.openjpa.persistence.Type;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;

@Entity
public class AuditedEntry
implements PersistenceCapable {
    @Id
    @GeneratedValue
    private long id;
    @ManyToOne(cascade={CascadeType.MERGE})
    @Type(value=PersistenceCapable.class)
    private Object audited;
    @Enumerated(value=EnumType.STRING)
    private AuditableOperation operation;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Timestamp ts;
    @ElementCollection
    private List<String> updatedFields;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$lang$Object;
    static /* synthetic */ Class class$Lorg$apache$openjpa$audit$AuditableOperation;
    static /* synthetic */ Class class$Ljava$sql$Timestamp;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Lorg$apache$openjpa$audit$AuditedEntry;
    private transient Object pcDetachedState;

    public AuditedEntry(Audited a) {
        this.audited = a.getManagedObject();
        this.ts = new Timestamp(new Date().getTime());
        this.operation = a.getType();
        if (this.operation == AuditableOperation.UPDATE) {
            this.updatedFields = Arrays.asList(a.getUpdatedFields());
        }
    }

    public Object getAudited() {
        return AuditedEntry.pcGetaudited(this);
    }

    public AuditableOperation getOperation() {
        return AuditedEntry.pcGetoperation(this);
    }

    public Timestamp getTimestamp() {
        return AuditedEntry.pcGetts(this);
    }

    public long getId() {
        return AuditedEntry.pcGetid(this);
    }

    public List<String> getUpdatedFields() {
        return AuditedEntry.pcGetupdatedFields(this);
    }

    public int pcGetEnhancementContractVersion() {
        return 196634845;
    }

    public AuditedEntry() {
    }

    static {
        pcFieldNames = new String[]{"audited", "id", "operation", "ts", "updatedFields"};
        Class[] classArray = new Class[5];
        Class clazz = class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = AuditedEntry.class$("java.lang.Object"));
        classArray[0] = clazz;
        classArray[1] = Long.TYPE;
        Class clazz2 = class$Lorg$apache$openjpa$audit$AuditableOperation != null ? class$Lorg$apache$openjpa$audit$AuditableOperation : (class$Lorg$apache$openjpa$audit$AuditableOperation = AuditedEntry.class$("org.apache.openjpa.audit.AuditableOperation"));
        classArray[2] = clazz2;
        Class clazz3 = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = AuditedEntry.class$("java.sql.Timestamp"));
        classArray[3] = clazz3;
        Class clazz4 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = AuditedEntry.class$("java.util.List"));
        classArray[4] = clazz4;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{10, 26, 26, 26, 5};
        Class clazz5 = class$Lorg$apache$openjpa$audit$AuditedEntry != null ? class$Lorg$apache$openjpa$audit$AuditedEntry : (class$Lorg$apache$openjpa$audit$AuditedEntry = AuditedEntry.class$("org.apache.openjpa.audit.AuditedEntry"));
        PCRegistry.register((Class)clazz5, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"AuditedEntry", (PersistenceCapable)new AuditedEntry());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.audited = null;
        this.id = 0L;
        this.operation = null;
        this.ts = null;
        this.updatedFields = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        AuditedEntry auditedEntry = new AuditedEntry();
        if (bl) {
            auditedEntry.pcClearFields();
        }
        auditedEntry.pcStateManager = stateManager;
        auditedEntry.pcCopyKeyFieldsFromObjectId(object);
        return auditedEntry;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        AuditedEntry auditedEntry = new AuditedEntry();
        if (bl) {
            auditedEntry.pcClearFields();
        }
        auditedEntry.pcStateManager = stateManager;
        return auditedEntry;
    }

    protected static int pcGetManagedFieldCount() {
        return 5;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.audited = this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.id = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.operation = (AuditableOperation)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.ts = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.updatedFields = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.audited);
                return;
            }
            case 1: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.id);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.operation);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.ts);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.updatedFields);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(AuditedEntry auditedEntry, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.audited = auditedEntry.audited;
                return;
            }
            case 1: {
                this.id = auditedEntry.id;
                return;
            }
            case 2: {
                this.operation = auditedEntry.operation;
                return;
            }
            case 3: {
                this.ts = auditedEntry.ts;
                return;
            }
            case 4: {
                this.updatedFields = auditedEntry.updatedFields;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        AuditedEntry auditedEntry = (AuditedEntry)object;
        if (auditedEntry.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(auditedEntry, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        LongId longId = (LongId)object;
        fieldConsumer.storeLongField(1 + pcInheritedFieldCount, longId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        LongId longId = (LongId)object;
        this.id = longId.getId();
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$openjpa$audit$AuditedEntry != null ? class$Lorg$apache$openjpa$audit$AuditedEntry : (class$Lorg$apache$openjpa$audit$AuditedEntry = AuditedEntry.class$("org.apache.openjpa.audit.AuditedEntry"));
        return new LongId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$openjpa$audit$AuditedEntry != null ? class$Lorg$apache$openjpa$audit$AuditedEntry : (class$Lorg$apache$openjpa$audit$AuditedEntry = AuditedEntry.class$("org.apache.openjpa.audit.AuditedEntry"));
        return new LongId(clazz, this.id);
    }

    private static final Object pcGetaudited(AuditedEntry auditedEntry) {
        if (auditedEntry.pcStateManager == null) {
            return auditedEntry.audited;
        }
        int n = pcInheritedFieldCount + 0;
        auditedEntry.pcStateManager.accessingField(n);
        return auditedEntry.audited;
    }

    private static final void pcSetaudited(AuditedEntry auditedEntry, Object object) {
        if (auditedEntry.pcStateManager == null) {
            auditedEntry.audited = object;
            return;
        }
        auditedEntry.pcStateManager.settingObjectField((PersistenceCapable)auditedEntry, pcInheritedFieldCount + 0, auditedEntry.audited, object, 0);
    }

    private static final long pcGetid(AuditedEntry auditedEntry) {
        if (auditedEntry.pcStateManager == null) {
            return auditedEntry.id;
        }
        int n = pcInheritedFieldCount + 1;
        auditedEntry.pcStateManager.accessingField(n);
        return auditedEntry.id;
    }

    private static final void pcSetid(AuditedEntry auditedEntry, long l) {
        if (auditedEntry.pcStateManager == null) {
            auditedEntry.id = l;
            return;
        }
        auditedEntry.pcStateManager.settingLongField((PersistenceCapable)auditedEntry, pcInheritedFieldCount + 1, auditedEntry.id, l, 0);
    }

    private static final AuditableOperation pcGetoperation(AuditedEntry auditedEntry) {
        if (auditedEntry.pcStateManager == null) {
            return auditedEntry.operation;
        }
        int n = pcInheritedFieldCount + 2;
        auditedEntry.pcStateManager.accessingField(n);
        return auditedEntry.operation;
    }

    private static final void pcSetoperation(AuditedEntry auditedEntry, AuditableOperation auditableOperation) {
        if (auditedEntry.pcStateManager == null) {
            auditedEntry.operation = auditableOperation;
            return;
        }
        auditedEntry.pcStateManager.settingObjectField((PersistenceCapable)auditedEntry, pcInheritedFieldCount + 2, (Object)auditedEntry.operation, (Object)auditableOperation, 0);
    }

    private static final Timestamp pcGetts(AuditedEntry auditedEntry) {
        if (auditedEntry.pcStateManager == null) {
            return auditedEntry.ts;
        }
        int n = pcInheritedFieldCount + 3;
        auditedEntry.pcStateManager.accessingField(n);
        return auditedEntry.ts;
    }

    private static final void pcSetts(AuditedEntry auditedEntry, Timestamp timestamp) {
        if (auditedEntry.pcStateManager == null) {
            auditedEntry.ts = timestamp;
            return;
        }
        auditedEntry.pcStateManager.settingObjectField((PersistenceCapable)auditedEntry, pcInheritedFieldCount + 3, (Object)auditedEntry.ts, (Object)timestamp, 0);
    }

    private static final List pcGetupdatedFields(AuditedEntry auditedEntry) {
        if (auditedEntry.pcStateManager == null) {
            return auditedEntry.updatedFields;
        }
        int n = pcInheritedFieldCount + 4;
        auditedEntry.pcStateManager.accessingField(n);
        return auditedEntry.updatedFields;
    }

    private static final void pcSetupdatedFields(AuditedEntry auditedEntry, List list) {
        if (auditedEntry.pcStateManager == null) {
            auditedEntry.updatedFields = list;
            return;
        }
        auditedEntry.pcStateManager.settingObjectField((PersistenceCapable)auditedEntry, pcInheritedFieldCount + 4, auditedEntry.updatedFields, (Object)list, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.id != 0L) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

