/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.xmlmapping.query;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import junit.textui.TestRunner;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;
import org.apache.openjpa.persistence.xmlmapping.entities.Customer;
import org.apache.openjpa.persistence.xmlmapping.entities.EAddress;
import org.apache.openjpa.persistence.xmlmapping.entities.Order;
import org.apache.openjpa.persistence.xmlmapping.xmlbindings.myaddress.Address;
import org.apache.openjpa.persistence.xmlmapping.xmlbindings.myaddress.CANAddress;
import org.apache.openjpa.persistence.xmlmapping.xmlbindings.myaddress.ObjectFactory;
import org.apache.openjpa.persistence.xmlmapping.xmlbindings.myaddress.USAAddress;

public class TestXMLCustomerOrder
extends SingleEMFTestCase {
    private static final int ORDER_1_OID = 10;
    private static final double ORDER_1_AMOUNT = 850.0;
    private static final boolean ORDER_1_DELIVERED = false;
    private static final int ORDER_2_OID = 20;
    private static final double ORDER_2_AMOUNT = 1000.0;
    private static final boolean ORDER_2_DELIVERED = false;

    public void setUp() {
        this.setUp(Customer.class, Customer.CustomerKey.class, Order.class, EAddress.class, DROP_TABLES);
        this.setTestsDisabled(!this.dictionarySupportsXMLColumn());
        if (this.isTestsDisabled()) {
            this.getLog().trace((Object)"TestXMLCustomerOrder() - Skipping all tests - No XML Column support");
            return;
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        this.persistEntities((EntityManager)em);
        em.getTransaction().commit();
        em.close();
    }

    public void testXMLFieldProjection() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        List addrs = em.createQuery("select o.shipAddress from Order o order by o.oid").getResultList();
        TestXMLCustomerOrder.assertEquals((int)2, (int)addrs.size());
        Address addressFromDb = (Address)addrs.get(0);
        Address address = this.createUSAAddress("Harry's Auto");
        TestXMLCustomerOrder.assertEquals((String)address.toString(), (String)addressFromDb.toString());
        addressFromDb = (Address)addrs.get(1);
        address = this.createCANAddress("A&J Auto");
        TestXMLCustomerOrder.assertEquals((String)address.toString(), (String)addressFromDb.toString());
        em.close();
    }

    public void testXMLFieldInEntity() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        List orders = em.createQuery("select o from Order o order by o.oid").getResultList();
        TestXMLCustomerOrder.assertEquals((int)2, (int)orders.size());
        Order orderFromDb = (Order)orders.get(0);
        Address addressFromDb = orderFromDb.getShipAddress();
        Address address = this.createUSAAddress("Harry's Auto");
        TestXMLCustomerOrder.assertEquals((String)address.toString(), (String)addressFromDb.toString());
        orderFromDb = (Order)orders.get(1);
        addressFromDb = orderFromDb.getShipAddress();
        address = this.createCANAddress("A&J Auto");
        TestXMLCustomerOrder.assertEquals((String)address.toString(), (String)addressFromDb.toString());
        em.close();
    }

    public void testXMLStringToXMLStringComparison() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        List orders = em.createQuery("select o, o2 from Order o, Order o2 where o.shipAddress.city = o2.shipAddress.city order by o.oid").getResultList();
        TestXMLCustomerOrder.assertEquals((int)2, (int)orders.size());
        Object[] ordersFromDb = (Object[])orders.get(0);
        Order order1 = (Order)ordersFromDb[0];
        Order order2 = (Order)ordersFromDb[1];
        TestXMLCustomerOrder.assertEquals((int)10, (int)order1.getOid());
        this.assertOrdersEqual(order1, order2);
        ordersFromDb = (Object[])orders.get(1);
        order1 = (Order)ordersFromDb[0];
        order2 = (Order)ordersFromDb[1];
        TestXMLCustomerOrder.assertEquals((int)20, (int)order1.getOid());
        this.assertOrdersEqual(order1, order2);
        em.close();
    }

    public void testXMLStringToEmbeddedStringComparison() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        List orders = em.createQuery("select o from Order o, Customer c where o.shipAddress.city = c.address.city").getResultList();
        TestXMLCustomerOrder.assertEquals((int)1, (int)orders.size());
        Order order = (Order)orders.get(0);
        TestXMLCustomerOrder.assertEquals((int)10, (int)order.getOid());
        em.close();
    }

    public void testXMLStringToConstantStringComparison() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        List orders = em.createQuery("select o from Order o where o.shipAddress.city = 'San Jose'").getResultList();
        TestXMLCustomerOrder.assertEquals((int)1, (int)orders.size());
        Order order = (Order)orders.get(0);
        TestXMLCustomerOrder.assertEquals((int)10, (int)order.getOid());
        em.close();
    }

    public void testXMLStringToParameterStringComparison() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query query = em.createQuery("select o from Order o where o.shipAddress.city = :city");
        query.setParameter("city", (Object)"San Jose");
        List orders = query.getResultList();
        TestXMLCustomerOrder.assertEquals((int)1, (int)orders.size());
        Order order = (Order)orders.get(0);
        TestXMLCustomerOrder.assertEquals((int)10, (int)order.getOid());
        em.close();
    }

    public void testParameterStringToXMLStringComparison() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query query = em.createQuery("select o from Order o where :city = o.shipAddress.city");
        query.setParameter("city", (Object)"San Jose");
        List orders = query.getResultList();
        TestXMLCustomerOrder.assertEquals((int)1, (int)orders.size());
        Order order = (Order)orders.get(0);
        TestXMLCustomerOrder.assertEquals((int)10, (int)order.getOid());
        em.close();
    }

    public void testUpdate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Order order = (Order)em.find(Order.class, (Object)10);
        USAAddress address = (USAAddress)order.getShipAddress();
        address.setCity("Cupertino");
        address.setZIP(95014);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        order = (Order)em.find(Order.class, (Object)10);
        address = (USAAddress)order.getShipAddress();
        TestXMLCustomerOrder.assertEquals((String)"Cupertino", (String)address.getCity());
        TestXMLCustomerOrder.assertEquals((int)95014, (int)address.getZIP());
        em.getTransaction().commit();
        em.close();
    }

    public void testNullify() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Order order = (Order)em.find(Order.class, (Object)10);
        order.setShipAddress(null);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        order = (Order)em.find(Order.class, (Object)10);
        Address address = order.getShipAddress();
        TestXMLCustomerOrder.assertNull((Object)address);
        em.getTransaction().commit();
        em.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testXMLStringToConstantIntComparison() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            em.createQuery("select o from Order o where o.shipAddress.city = 95141").getResultList();
        }
        catch (IllegalArgumentException iae) {
            return;
        }
        finally {
            em.close();
        }
        TestXMLCustomerOrder.fail((String)"createQuery should throw IllegalArgumentException.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testXMLListToConstantStringComparison() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            em.createQuery("select o from Order o where o.shipAddress.street = '555 Bailey'").getResultList();
        }
        catch (IllegalArgumentException iae) {
            return;
        }
        finally {
            em.close();
        }
        TestXMLCustomerOrder.fail((String)"createQuery should throw IllegalArgumentException.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubclassPropertyInXMLFieldComparison() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            em.createQuery("select o from Order o where o.shipAddress.zip = 95141").getResultList();
        }
        catch (IllegalArgumentException iae) {
            return;
        }
        finally {
            em.close();
        }
        TestXMLCustomerOrder.fail((String)"createQuery should throw IllegalArgumentException.");
    }

    public static void main(String[] args) {
        TestRunner.run(TestXMLCustomerOrder.class);
    }

    private void persistEntities(EntityManager em) {
        Customer c2 = new Customer();
        c2.setCid(new Customer.CustomerKey("USA", 2));
        c2.setName("A&J Auto");
        c2.setRating(Customer.CreditRating.GOOD);
        c2.setAddress(new EAddress("2480 Campbell Ave", "Campbell", "CA", "95123"));
        em.persist((Object)c2);
        Customer c1 = new Customer();
        c1.setCid(new Customer.CustomerKey("USA", 1));
        c1.setName("Harry's Auto");
        c1.setRating(Customer.CreditRating.GOOD);
        c1.setAddress(new EAddress("12500 Monterey", "San Jose", "CA", "95141"));
        em.persist((Object)c1);
        Order o1 = new Order(10, 850.0, false, c1);
        o1.setShipAddress(this.createUSAAddress(c1.getName()));
        em.persist((Object)o1);
        Order o2 = new Order(20, 1000.0, false, c1);
        o2.setShipAddress(this.createCANAddress(c2.getName()));
        em.persist((Object)o2);
    }

    private boolean dictionarySupportsXMLColumn() {
        OpenJPAEntityManagerFactorySPI emf = this.createEMF(new Object[0]);
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        DBDictionary dict = ((JDBCConfiguration)em.getConfiguration()).getDBDictionaryInstance();
        this.closeEMF((EntityManagerFactory)emf);
        return dict.supportsXMLColumn;
    }

    private USAAddress createUSAAddress(String name) {
        USAAddress address = new ObjectFactory().createUSAAddress();
        address.setName(name);
        address.getStreet().add("12500 Monterey");
        address.setCity("San Jose");
        address.setState("CA");
        address.setZIP(new Integer("95141"));
        return address;
    }

    private CANAddress createCANAddress(String name) {
        CANAddress address = new ObjectFactory().createCANAddress();
        address.setName(name);
        address.getStreet().add("123 Warden Road");
        address.setCity("Markham");
        address.setPostalCode("L6G 1C7");
        address.setProvince("ON");
        return address;
    }

    private void assertOrdersEqual(Order o1, Order o2) {
        TestXMLCustomerOrder.assertEquals((int)o1.getOid(), (int)o2.getOid());
        TestXMLCustomerOrder.assertEquals((Object)o1.getAmount(), (Object)o2.getAmount());
        TestXMLCustomerOrder.assertEquals((boolean)o1.isDelivered(), (boolean)o2.isDelivered());
    }
}

