/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.xmlmapping.entities;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Version;
import org.apache.openjpa.persistence.Persistent;
import org.apache.openjpa.persistence.jdbc.Strategy;
import org.apache.openjpa.persistence.xmlmapping.entities.Customer;
import org.apache.openjpa.persistence.xmlmapping.xmlbindings.myaddress.Address;

@Entity
@Table(name="TORDERXML")
public class Order {
    @Id
    int oid;
    double amount;
    boolean delivered;
    @ManyToOne(fetch=FetchType.LAZY)
    Customer customer;
    @Persistent
    @Strategy(value="org.apache.openjpa.jdbc.meta.strats.XMLValueHandler")
    Address shipAddress;
    @Version
    long version;

    public Order() {
    }

    public Order(int id, double amt, boolean delivered, Customer c) {
        this.oid = id;
        this.amount = amt;
        this.delivered = delivered;
        this.customer = c;
        if (c != null) {
            c.getOrders().add(this);
        }
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public boolean isDelivered() {
        return this.delivered;
    }

    public void setDelivered(boolean delivered) {
        this.delivered = delivered;
    }

    public int getOid() {
        return this.oid;
    }

    public String toString() {
        return "Order:" + this.oid + " amount:" + this.amount + " delivered:" + this.delivered + " customer:" + (this.customer != null ? this.customer.getCid() : Integer.valueOf(-1));
    }

    public Address getShipAddress() {
        return this.shipAddress;
    }

    public void setShipAddress(Address shipAddress) {
        this.shipAddress = shipAddress;
    }
}

