/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.xml;

import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.embed.attrOverrides.AnnoOverEmbed;
import org.apache.openjpa.persistence.test.SingleEMTestCase;
import org.apache.openjpa.persistence.xml.SimpleXmlEntity;

public class TestSimpleXmlEntity
extends SingleEMTestCase {
    public void setUp() {
        this.setUp(AnnoOverEmbed.class, CLEAR_TABLES);
    }

    protected String getPersistenceUnitName() {
        return "xml-persistence-unit";
    }

    public void testId() {
        this.em.getTransaction().begin();
        SimpleXmlEntity e = new SimpleXmlEntity();
        this.em.persist((Object)e);
        this.em.flush();
        TestSimpleXmlEntity.assertNotNull((Object)e.getId());
        try {
            Integer.parseInt(e.getId());
            TestSimpleXmlEntity.fail((String)("uuid-based id should not be an integer; was " + e.getId()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.em.getTransaction().rollback();
    }

    public void testNamedQueryInXmlNamedEntity() {
        this.em.createNamedQuery("SimpleXml.findAll").getResultList();
    }

    public void testNamedQueryInXmlUsingShortClassName() {
        try {
            this.em.createNamedQuery("SimpleXmlEntity.findAll").getResultList();
            TestSimpleXmlEntity.fail((String)"should not be able to execute query using short class name for entity that has an entity name specified");
        }
        catch (ArgumentException ae) {
            this.assertMarkerInErrorMessage((Exception)((Object)ae), "The name \"SimpleXmlEntity\" is not a recognized entity");
        }
    }

    public void testNamedEntityInDynamicQuery() {
        this.em.createQuery("select o from SimpleXml o").getResultList();
    }

    public void testShortClassNameInDynamicQuery() {
        try {
            this.em.createQuery("select o from SimpleXmlEntity o").getResultList();
            TestSimpleXmlEntity.fail((String)"should not be able to execute query using short class name for entity that has an entity name specified");
        }
        catch (ArgumentException ae) {
            this.assertMarkerInErrorMessage((Exception)((Object)ae), "The name \"SimpleXmlEntity\" is not a recognized entity");
        }
    }

    void assertMarkerInErrorMessage(Exception ex, String marker) {
        String message = ex.getMessage();
        TestSimpleXmlEntity.assertTrue((String)("Can not find [" + marker + "] in the message [" + message + "]"), (message.indexOf(marker) != -1 ? 1 : 0) != 0);
    }
}

