/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.validation;

import java.util.HashMap;
import javax.persistence.ValidationMode;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.PersistenceException;
import org.apache.openjpa.persistence.query.SimpleEntity;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestValidationFactory
extends SingleEMFTestCase {
    public void setUp() {
        super.setUp(CLEAR_TABLES, SimpleEntity.class);
    }

    public void testValidationFactory1() {
        this.getLog().trace((Object)"testValidationFactory1() - Default is null");
        OpenJPAEntityManagerFactory emf = null;
        emf = OpenJPAPersistence.createEntityManagerFactory((String)"simple-none-mode", (String)"org/apache/openjpa/persistence/validation/persistence.xml");
        TestValidationFactory.assertNotNull((Object)emf);
        OpenJPAConfiguration conf = emf.getConfiguration();
        TestValidationFactory.assertNotNull((Object)conf);
        TestValidationFactory.assertEquals((String)"Default ValidationFactory", null, (Object)conf.getValidationFactoryInstance());
    }

    public void testValidationFactory2() {
        this.getLog().trace((Object)"testValidationFactory2() - ignored invalid factory");
        OpenJPAEntityManagerFactory emf = null;
        HashMap props = new HashMap();
        props.put("javax.persistence.validation.factory", ((Object)((Object)this)).getClass());
        emf = OpenJPAPersistence.createEntityManagerFactory((String)"simple-none-mode", (String)"org/apache/openjpa/persistence/validation/persistence.xml", props);
        TestValidationFactory.assertNotNull((Object)emf);
        OpenJPAConfiguration conf = emf.getConfiguration();
        TestValidationFactory.assertNotNull((Object)conf);
        TestValidationFactory.assertEquals((String)"ValidationFactory", ((Object)((Object)this)).getClass(), (Object)conf.getValidationFactoryInstance());
    }

    public void testValidationFactory3() {
        this.getLog().trace((Object)"testValidationFactory3() - optional invalid factory");
        OpenJPAEntityManagerFactory emf = null;
        HashMap props = new HashMap();
        props.put("javax.persistence.validation.factory", ((Object)((Object)this)).getClass());
        emf = OpenJPAPersistence.createEntityManagerFactory((String)"simple-auto-mode", (String)"org/apache/openjpa/persistence/validation/persistence.xml", props);
        TestValidationFactory.assertNotNull((Object)emf);
        OpenJPAConfiguration conf = emf.getConfiguration();
        TestValidationFactory.assertNotNull((Object)conf);
        TestValidationFactory.assertEquals((String)"ValidationFactory", ((Object)((Object)this)).getClass(), (Object)conf.getValidationFactoryInstance());
    }

    public void testValidationFactory4() {
        this.getLog().trace((Object)"testValidationFactory4() - required invalid factory");
        OpenJPAEntityManagerFactory emf = null;
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("javax.persistence.validation.factory", ((Object)((Object)this)).getClass());
        props.put("javax.persistence.validation.mode", String.valueOf(ValidationMode.CALLBACK));
        try {
            emf = OpenJPAPersistence.createEntityManagerFactory((String)"simple-callback-mode", (String)"org/apache/openjpa/persistence/validation/persistence.xml", props);
            TestValidationFactory.assertNotNull((Object)emf);
            OpenJPAConfiguration conf = emf.getConfiguration();
            TestValidationFactory.assertNotNull((Object)conf);
            TestValidationFactory.assertEquals((String)"Validation mode", (String)String.valueOf(ValidationMode.CALLBACK), (String)conf.getValidationMode());
            TestValidationFactory.fail((String)"Expected an exception when ValidationMode=CALLBACK and an invalid ValidatorFactory is provided.");
        }
        catch (PersistenceException e) {
            this.getLog().trace((Object)"testValidationFactory4() - caught expected PersistenceException", (Throwable)e);
        }
    }
}

