/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.util;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Random;
import javax.persistence.Persistence;
import javax.persistence.PersistenceUtil;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;
import org.apache.openjpa.persistence.util.EagerEmbed;
import org.apache.openjpa.persistence.util.EagerEmbedRel;
import org.apache.openjpa.persistence.util.EagerEntity;
import org.apache.openjpa.persistence.util.LazyEmbed;
import org.apache.openjpa.persistence.util.LazyEntity;
import org.apache.openjpa.persistence.util.RelEntity;

public class TestPersistenceUtil
extends SingleEMFTestCase {
    public void setUp() {
        this.setUp(CLEAR_TABLES, EagerEntity.class, LazyEmbed.class, LazyEntity.class, EagerEmbed.class, EagerEmbedRel.class, RelEntity.class);
    }

    public void testIsLoadedEager() {
        this.verifyIsLoadedEagerState(true);
    }

    public void testNotLoadedLazy() {
        this.verifyIsLoadedEagerState(false);
    }

    public void testIsLoadedLazy() {
        this.verifyIsLoadedLazyState(true);
    }

    public void testNotLoadedEager() {
        this.verifyIsLoadedEagerState(false);
    }

    public void testIsApplicationLoaded() {
        PersistenceUtil putil = Persistence.getPersistenceUtil();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EagerEntity ee = this.createEagerEntity();
        em.getTransaction().begin();
        em.persist((Object)ee);
        em.getTransaction().commit();
        em.clear();
        ee = (EagerEntity)em.getReference(EagerEntity.class, (Object)ee.getId());
        TestPersistenceUtil.assertNotNull((Object)ee);
        this.assertEagerLoadState(putil, ee, false);
        ee.setName("AppEagerName");
        EagerEmbed emb = this.createEagerEmbed();
        ee.setEagerEmbed(emb);
        this.assertEagerLoadState(putil, ee, true);
        TestPersistenceUtil.assertEquals((String)"AppEagerName", (String)ee.getName());
        TestPersistenceUtil.assertEquals((Object)emb, (Object)ee.getEagerEmbed());
        em.close();
    }

    public void testIsDetachLoaded() {
        PersistenceUtil putil = Persistence.getPersistenceUtil();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EagerEntity ee = this.createEagerEntity();
        em.getTransaction().begin();
        em.persist((Object)ee);
        em.getTransaction().commit();
        em.clear();
        TestPersistenceUtil.assertEquals((boolean)true, (boolean)putil.isLoaded((Object)ee));
        em.close();
    }

    private void verifyIsLoadedEagerState(boolean loaded) {
        PersistenceUtil putil = Persistence.getPersistenceUtil();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EagerEntity ee = this.createEagerEntity();
        TestPersistenceUtil.assertEquals((boolean)true, (boolean)putil.isLoaded((Object)ee));
        TestPersistenceUtil.assertEquals((boolean)true, (boolean)putil.isLoaded((Object)ee, "id"));
        em.getTransaction().begin();
        em.persist((Object)ee);
        em.getTransaction().commit();
        em.clear();
        ee = loaded ? (EagerEntity)em.find(EagerEntity.class, (Object)ee.getId()) : (EagerEntity)em.getReference(EagerEntity.class, (Object)ee.getId());
        TestPersistenceUtil.assertEquals((boolean)loaded, (boolean)putil.isLoaded((Object)ee));
        TestPersistenceUtil.assertEquals((boolean)loaded, (boolean)putil.isLoaded((Object)ee, "id"));
        TestPersistenceUtil.assertEquals((boolean)loaded, (boolean)putil.isLoaded((Object)ee, "name"));
        TestPersistenceUtil.assertEquals((boolean)loaded, (boolean)putil.isLoaded((Object)ee, "eagerEmbed"));
        TestPersistenceUtil.assertEquals((boolean)true, (boolean)putil.isLoaded((Object)ee, "transField"));
        em.close();
    }

    private void verifyIsLoadedLazyState(boolean loaded) {
        PersistenceUtil putil = Persistence.getPersistenceUtil();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        LazyEntity le = this.createLazyEntity();
        TestPersistenceUtil.assertEquals((boolean)true, (boolean)putil.isLoaded((Object)le));
        TestPersistenceUtil.assertEquals((boolean)true, (boolean)putil.isLoaded((Object)le, "id"));
        em.getTransaction().begin();
        em.persist((Object)le);
        em.getTransaction().commit();
        em.clear();
        le = loaded ? (LazyEntity)em.find(LazyEntity.class, (Object)le.getId()) : (LazyEntity)em.getReference(LazyEntity.class, (Object)le.getId());
        TestPersistenceUtil.assertEquals((boolean)loaded, (boolean)putil.isLoaded((Object)le));
        TestPersistenceUtil.assertEquals((boolean)loaded, (boolean)putil.isLoaded((Object)le, "id"));
        TestPersistenceUtil.assertEquals((boolean)false, (boolean)putil.isLoaded((Object)le, "name"));
        TestPersistenceUtil.assertEquals((boolean)loaded, (boolean)putil.isLoaded((Object)le, "lazyEmbed"));
        TestPersistenceUtil.assertEquals((boolean)true, (boolean)putil.isLoaded((Object)le, "transField"));
        em.close();
    }

    private EagerEntity createEagerEntity() {
        EagerEntity ee = new EagerEntity();
        ee.setId(new Random().nextInt());
        ee.setName("EagerEntity");
        EagerEmbed emb = this.createEagerEmbed();
        ee.setEagerEmbed(emb);
        return ee;
    }

    private EagerEmbed createEagerEmbed() {
        EagerEmbed emb = new EagerEmbed();
        emb.setEndDate(new Date(System.currentTimeMillis()));
        emb.setStartDate(new Date(System.currentTimeMillis()));
        return emb;
    }

    private LazyEntity createLazyEntity() {
        LazyEntity le = new LazyEntity();
        le.setId(new Random().nextInt());
        le.setName("LazyEntity");
        LazyEmbed emb = new LazyEmbed();
        emb.setEndDate(new Date(System.currentTimeMillis()));
        emb.setStartDate(new Date(System.currentTimeMillis()));
        le.setLazyEmbed(emb);
        RelEntity re = new RelEntity();
        re.setName("My ent");
        ArrayList<RelEntity> rel = new ArrayList<RelEntity>();
        rel.add(new RelEntity());
        le.setRelEntities(rel);
        return le;
    }

    private void assertEagerLoadState(PersistenceUtil putil, Object ent, boolean state) {
        TestPersistenceUtil.assertEquals((boolean)state, (boolean)putil.isLoaded(ent));
        TestPersistenceUtil.assertEquals((boolean)state, (boolean)putil.isLoaded(ent, "id"));
        TestPersistenceUtil.assertEquals((boolean)state, (boolean)putil.isLoaded(ent, "name"));
        TestPersistenceUtil.assertEquals((boolean)state, (boolean)putil.isLoaded(ent, "eagerEmbed"));
        TestPersistenceUtil.assertEquals((boolean)true, (boolean)putil.isLoaded(ent, "transField"));
    }
}

