/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.test;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.test.AbstractCachedEMFTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SingleEMFTestCase
extends AbstractCachedEMFTestCase {
    protected OpenJPAEntityManagerFactorySPI emf;

    public void setUp() throws Exception {
        super.setUp();
        this.setUp(new Object[0]);
    }

    protected void setUp(Object ... props) {
        this.emf = this.createEMF(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.emf == null) {
            return;
        }
        try {
            this.clear((EntityManagerFactory)this.emf);
        }
        catch (Exception e) {
            if (this.testResult.wasSuccessful()) {
                throw e;
            }
        }
        finally {
            this.closeEMF((EntityManagerFactory)this.emf);
        }
    }

    protected ClassMapping getMapping(String name) {
        return (ClassMapping)this.emf.getConfiguration().getMetaDataRepositoryInstance().getMetaData(name, ((Object)((Object)this)).getClass().getClassLoader(), true);
    }

    protected ClassMapping getMapping(Class<?> entityClass) {
        return (ClassMapping)this.emf.getConfiguration().getMetaDataRepositoryInstance().getMetaData(entityClass, ((Object)((Object)this)).getClass().getClassLoader(), true);
    }

    public int count(String alias) {
        return ((Number)this.emf.createEntityManager().createQuery("SELECT COUNT(p) FROM " + alias + " p").getSingleResult()).intValue();
    }

    public int count(Class<?> c) {
        return this.count(this.getAlias(c));
    }

    public <T> List<T> getAll(Class<T> t) {
        return this.emf.createEntityManager().createQuery("SELECT p FROM " + this.getAlias(t) + " p").getResultList();
    }

    public <T> List<T> getAll(EntityManager em, Class<T> t) {
        return em.createQuery("SELECT p FROM " + this.getAlias(t) + " p").getResultList();
    }

    public String getAlias(Class<?> t) {
        return this.emf.getConfiguration().getMetaDataRepositoryInstance().getMetaData(t, null, true).getTypeAlias();
    }

    protected ClassMapping[] getMappings() {
        return (ClassMapping[])this.emf.getConfiguration().getMetaDataRepositoryInstance().getMetaDatas();
    }

    protected void setUnsupportedDatabases(Class<?> ... dbs) {
        OpenJPAEntityManagerFactorySPI tempEMF = this.emf;
        if (tempEMF == null) {
            tempEMF = this.createEMF(new Object[0]);
        }
        DBDictionary dict = ((JDBCConfiguration)tempEMF.getConfiguration()).getDBDictionaryInstance();
        for (Class<?> db : dbs) {
            if (!dict.getClass().getCanonicalName().equalsIgnoreCase(db.getCanonicalName())) continue;
            this.setTestsDisabled(true);
            break;
        }
        if (this.emf == null) {
            this.closeEMF((EntityManagerFactory)tempEMF);
        }
    }

    protected void setSupportedDatabases(Class<?> ... dbs) {
        OpenJPAEntityManagerFactorySPI tempEMF = this.emf;
        if (tempEMF == null) {
            tempEMF = this.createEMF(new Object[0]);
        }
        DBDictionary dict = ((JDBCConfiguration)tempEMF.getConfiguration()).getDBDictionaryInstance();
        boolean supportedDB = false;
        for (Class<?> db : dbs) {
            if (!dict.getClass().getCanonicalName().equalsIgnoreCase(db.getCanonicalName())) continue;
            supportedDB = true;
            break;
        }
        this.setTestsDisabled(!supportedDB);
        if (this.emf == null) {
            this.closeEMF((EntityManagerFactory)tempEMF);
        }
    }

    protected Log getLog() {
        return this.emf.getConfiguration().getLog("Tests");
    }

    protected String getForUpdateClause() {
        DBDictionary dict = ((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance();
        if (dict.forUpdateClause != null) {
            return dict.forUpdateClause;
        }
        if (dict.tableForUpdateClause != null) {
            return dict.tableForUpdateClause;
        }
        return "";
    }
}

