/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.openjpa.lib.jdbc.AbstractJDBCListener;
import org.apache.openjpa.lib.jdbc.JDBCEvent;
import org.apache.openjpa.lib.jdbc.JDBCListener;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SQLListenerTestCase
extends SingleEMFTestCase {
    private static String _nl = System.getProperty("line.separator");
    protected List<String> sql = new ArrayList<String>();

    @Override
    public void setUp(Object ... props) {
        Object[] copy = new Object[props.length + 2];
        System.arraycopy(props, 0, copy, 0, props.length);
        copy[copy.length - 2] = "openjpa.jdbc.JDBCListeners";
        copy[copy.length - 1] = new JDBCListener[]{new Listener()};
        super.setUp(copy);
    }

    public void assertSQL(String sqlExp) {
        for (String statement : this.sql) {
            if (!statement.matches(sqlExp)) continue;
            return;
        }
        SQLListenerTestCase.fail((String)("Expected regular expression\r\n <" + sqlExp + ">\r\n to have existed in SQL statements: \r\n" + this.toString(this.sql)));
    }

    public void assertNotSQL(String sqlExp) {
        for (String statement : this.sql) {
            if (!statement.matches(sqlExp)) continue;
            SQLListenerTestCase.fail((String)("Regular expression\r\n <" + sqlExp + ">\r\n should not have been executed in SQL statements:" + "\r\n" + this.toString(this.sql)));
            break;
        }
    }

    public void assertContainsSQL(String sqlExp) {
        for (String statement : this.sql) {
            if (!statement.contains(sqlExp)) continue;
            return;
        }
        SQLListenerTestCase.fail((String)("Expected regular expression\r\n <" + sqlExp + ">\r\n to be" + " contained in SQL statements: \r\n" + this.toString(this.sql)));
    }

    public void assertAllSQLInOrder(String ... expected) {
        this.assertSQLInOrder(false, expected);
    }

    public void assertAllExactSQLInOrder(String ... expected) {
        this.assertSQLInOrder(true, expected);
    }

    private void assertSQLInOrder(boolean exact, String ... expected) {
        boolean match = false;
        int sqlSize = this.sql.size();
        if (expected.length <= sqlSize) {
            int hits = 0;
            for (String executedSQL : this.sql) {
                if (executedSQL.matches(expected[hits]) && ++hits == expected.length) break;
            }
            boolean bl = match = hits == (exact ? sqlSize : expected.length);
        }
        if (!match) {
            StringBuilder sb = new StringBuilder();
            sb.append("Did not find SQL in expected order : ").append(_nl);
            for (String s : expected) {
                sb.append(s).append(_nl);
            }
            sb.append("SQL Statements issued : ");
            for (String s : this.sql) {
                sb.append(s).append(_nl);
            }
            SQLListenerTestCase.fail((String)sb.toString());
        }
    }

    public void assertAllSQLAnyOrder(String ... expected) {
        for (String statement : expected) {
            this.assertSQL(statement);
        }
    }

    public void assertNoneSQLAnyOrder(String ... expected) {
        for (String statement : expected) {
            this.assertNotSQL(statement);
        }
    }

    public void assertAnySQLAnyOrder(String ... expected) {
        for (String sqlExp : expected) {
            for (String statement : this.sql) {
                if (!statement.matches(sqlExp)) continue;
                return;
            }
        }
        SQLListenerTestCase.fail((String)("Expected regular expression\r\n <" + this.toString(Arrays.asList(expected)) + ">\r\n to be" + " contained in SQL statements: \r\n" + this.toString(this.sql)));
    }

    public int getSQLCount() {
        return this.sql.size();
    }

    public int resetSQL() {
        int tmp = this.sql.size();
        this.sql.clear();
        return tmp;
    }

    public String toString(List<String> list) {
        StringBuffer buf = new StringBuffer();
        for (String s : list) {
            buf.append(s).append("\r\n");
        }
        return buf.toString();
    }

    public class SQLAssertions {
        SQLAssertType type;
        String[] template;

        public SQLAssertions(SQLAssertType type, String ... template) {
            this.type = type;
            this.template = template;
        }

        public void validate() {
            switch (this.type) {
                case SQL: {
                    SQLListenerTestCase.this.assertSQL(this.template[0]);
                    break;
                }
                case NotSQL: {
                    SQLListenerTestCase.this.assertNotSQL(this.template[0]);
                    break;
                }
                case ContainsSQL: {
                    SQLListenerTestCase.this.assertContainsSQL(this.template[0]);
                    break;
                }
                case AllSQLInOrder: {
                    SQLListenerTestCase.this.assertAllSQLInOrder(this.template);
                    break;
                }
                case AllExactSQLInOrder: {
                    SQLListenerTestCase.this.assertAllExactSQLInOrder(this.template);
                    break;
                }
                case AllSQLAnyOrder: {
                    SQLListenerTestCase.this.assertAllSQLAnyOrder(this.template);
                    break;
                }
                case AnySQLAnyOrder: {
                    SQLListenerTestCase.this.assertAnySQLAnyOrder(this.template);
                    break;
                }
                case NoneSQLAnyOrder: {
                    SQLListenerTestCase.this.assertNoneSQLAnyOrder(this.template);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SQLAssertType {
        SQL,
        NotSQL,
        ContainsSQL,
        AllSQLInOrder,
        AllExactSQLInOrder,
        AllSQLAnyOrder,
        NoneSQLAnyOrder,
        AnySQLAnyOrder;

    }

    public class Listener
    extends AbstractJDBCListener {
        public void beforeExecuteStatement(JDBCEvent event) {
            if (event.getSQL() != null && SQLListenerTestCase.this.sql != null) {
                SQLListenerTestCase.this.sql.add(event.getSQL());
            }
        }
    }
}

