/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.test;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import serp.bytecode.Annotations;
import serp.bytecode.BCClass;
import serp.bytecode.BCMethod;
import serp.bytecode.Project;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassSelector {
    private List<String> _supers = new ArrayList<String>();
    private List<String> _interfaces = new ArrayList<String>();
    private List<String> _annotations = new ArrayList<String>();

    public static void main(String[] args) throws Exception {
        String dir = args.length == 0 ? System.getProperty("user.dir") : args[0];
        ClassSelector reader = new ClassSelector().addSuper("org.apache.openjpa.persistence.test.SingleEMTestCase").addSuper("org.apache.openjpa.persistence.test.SingleEMFTestCase").addSuper("org.apache.openjpa.persistence.kernel.BaseKernelTest").addSuper("org.apache.openjpa.persistence.query.BaseQueryTest").addSuper("org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest").addSuper("org.apache.openjpa.persistence.common.utils.AbstractTestCase").addAnnotation("org.apache.openjpa.persistence.test.AllowFailure");
        List<String> names = reader.list(new File(dir), true);
        String spec = reader.getSpecification();
        System.err.println("Found " + names.size() + " classes under " + dir + (spec.length() > 0 ? " that" : ""));
        System.err.println(spec);
        for (String name : names) {
            System.err.println(name);
        }
    }

    public List<String> list(File file, boolean recursive) {
        ArrayList<String> names = new ArrayList<String>();
        this.list(file, recursive, names);
        return names;
    }

    private void list(File file, boolean recursive, List<String> names) {
        String cls;
        if (file.isDirectory()) {
            if (recursive) {
                String[] dirs;
                String[] children;
                for (String name : children = file.list(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.endsWith(".class");
                    }
                })) {
                    this.list(new File(file, name), recursive, names);
                }
                for (String name : dirs = file.list(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return new File(dir, name).isDirectory();
                    }
                })) {
                    this.list(new File(file, name), recursive, names);
                }
            }
        } else if (file.getName().endsWith(".class") && (cls = this.select(file)) != null) {
            names.add(cls);
        }
    }

    public ClassSelector addSuper(String s) {
        this._supers.add(s);
        return this;
    }

    public ClassSelector addInterface(String s) {
        this._interfaces.add(s);
        return this;
    }

    public ClassSelector addAnnotation(String s) {
        this._annotations.add(s);
        return this;
    }

    private String select(File file) {
        try {
            BCClass bcls = new Project().loadClass(file);
            if (this.applyInheritanceFilter(bcls) && this.applyInterfaceFilter(bcls) && this.applyAnnotationFilter(bcls)) {
                return bcls.getName();
            }
        }
        catch (Exception e) {
            System.err.println("Error reading " + file.getAbsolutePath() + " : " + e);
        }
        return null;
    }

    private boolean applyInheritanceFilter(BCClass bcls) {
        if (this._supers.isEmpty()) {
            return true;
        }
        String superc = bcls.getSuperclassName();
        return this._supers.contains(superc);
    }

    private boolean applyInterfaceFilter(BCClass bcls) {
        if (this._interfaces.isEmpty()) {
            return true;
        }
        String[] ifaces = bcls.getInterfaceNames();
        if (ifaces == null || ifaces.length == 0) {
            return false;
        }
        for (String iface : ifaces) {
            if (!this._interfaces.contains(iface)) continue;
            return true;
        }
        return false;
    }

    private boolean applyAnnotationFilter(BCClass bcls) {
        BCMethod[] methods;
        if (this._annotations.isEmpty()) {
            return true;
        }
        Annotations annos = bcls.getDeclaredRuntimeAnnotations(false);
        if (this.hasAnnotation(annos)) {
            return true;
        }
        for (BCMethod m : methods = bcls.getDeclaredMethods()) {
            annos = m.getDeclaredRuntimeAnnotations(false);
            if (!this.hasAnnotation(annos)) continue;
            return true;
        }
        return false;
    }

    private boolean hasAnnotation(Annotations annos) {
        if (annos == null) {
            return false;
        }
        for (String anno : this._annotations) {
            if (annos.getAnnotation(anno) == null) continue;
            return true;
        }
        return false;
    }

    public String getSpecification() {
        int i;
        StringBuffer tmp = new StringBuffer();
        String and = "";
        if (!this._supers.isEmpty()) {
            tmp.append("\textends ");
            and = "and ";
            for (i = 0; i < this._supers.size(); ++i) {
                tmp.append(this._supers.get(i)).append(i != this._supers.size() - 1 ? "\r\n\t     or " : "\r\n");
            }
        }
        if (!this._interfaces.isEmpty()) {
            tmp.append("\t" + and + "implements ");
            and = "and ";
            for (i = 0; i < this._interfaces.size(); ++i) {
                tmp.append(this._interfaces.get(i)).append(i != this._interfaces.size() - 1 ? "\r\n\t        or " : "\r\n");
            }
        }
        if (!this._annotations.isEmpty()) {
            tmp.append("\t" + and + "annotatated with ");
            for (i = 0; i < this._annotations.size(); ++i) {
                tmp.append(this._annotations.get(i)).append(i != this._annotations.size() - 1 ? " or " : "\r\n");
            }
        }
        return tmp.toString();
    }
}

