/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.test;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.test.AbstractPersistenceTestCase;

public abstract class AbstractCachedEMFTestCase
extends AbstractPersistenceTestCase {
    private static FixedMap<EMFKey, OpenJPAEntityManagerFactorySPI> _emfs = new FixedMap();

    protected OpenJPAEntityManagerFactorySPI createNamedEMF(String pu, Object ... props) {
        Map<String, Object> map = this.getPropertiesMap(props);
        EMFKey key = new EMFKey(pu, map);
        OpenJPAEntityManagerFactorySPI oemf = (OpenJPAEntityManagerFactorySPI)_emfs.get(key);
        if (this._fresh || oemf == null || !oemf.isOpen()) {
            oemf = super.createNamedEMF(pu, props);
            if (!this._fresh) {
                _emfs.put(key, oemf);
            }
        }
        this._fresh = false;
        return oemf;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EMFKey {
        final String unit;
        final Map<String, Object> config;

        EMFKey(String unit, Map<String, Object> config) {
            this.unit = unit;
            this.config = config;
        }

        public int hashCode() {
            return (this.unit != null ? this.unit.hashCode() : 0) + ((Object)this.config).hashCode();
        }

        public boolean equals(Object other) {
            EMFKey that = (EMFKey)other;
            return (this.unit != null ? this.unit.equals(that.unit) : that.unit == null) && ((Object)this.config).equals(that.config);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FixedMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = -3153852097468390779L;

        private FixedMap() {
        }

        @Override
        public boolean removeEldestEntry(Map.Entry<K, V> entry) {
            return this.size() > 2;
        }
    }
}

