/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.spring;

import java.util.EnumSet;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.AutoDetachType;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.models.library.Book;
import org.apache.openjpa.persistence.models.library.Borrower;
import org.apache.openjpa.persistence.models.library.Subject;
import org.apache.openjpa.persistence.models.library.Volunteer;
import org.apache.openjpa.persistence.spring.LibService;
import org.apache.openjpa.persistence.spring.LibServiceImpl;
import org.apache.openjpa.persistence.spring.LibTestingService;
import org.apache.openjpa.persistence.spring.TransactionalEntityManagerFactory;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestLibService
extends SingleEMFTestCase
implements TransactionalEntityManagerFactory {
    private static EnumSet<AutoDetachType> txScope = EnumSet.allOf(AutoDetachType.class);
    private LibService service;

    public EntityManager getTransactionalEntityManager() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.setAutoDetach(txScope);
        return em;
    }

    public void setUp() {
        super.setUp(DROP_TABLES, Book.class, Borrower.class, Subject.class, Volunteer.class);
        LibTestingService libTestingService = new LibTestingService();
        libTestingService.setEntityManager((EntityManager)this.emf.createEntityManager());
        libTestingService.repopulateDB();
        libTestingService.close();
        this.service = new LibServiceImpl();
        this.service.setTransactionalEntityManagerFactory(this);
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.service = null;
    }

    public void testFindBookByTitle() {
        String title = "Gone Sailing";
        String qTitle = "\"" + title + "\"";
        String bName = "Dick";
        try {
            Book book = this.service.findBookByTitle(title);
            TestLibService.assertNotNull((String)("could not find the book " + qTitle), (Object)book);
            TestLibService.assertEquals((String)("the book found was not the book " + qTitle), (String)title, (String)book.getTitle());
            Borrower borrower = book.getBorrower();
            TestLibService.assertNotNull((String)("could not find the borrower " + bName), (Object)borrower);
            TestLibService.assertEquals((String)("the borrower found was not " + bName), (String)bName, (String)borrower.getName());
            Volunteer volunteer = borrower.getVolunteer();
            TestLibService.assertNotNull((String)("could not find " + bName + "'s volunteer status"), (Object)volunteer);
            TestLibService.assertTrue((String)("could not find the reference from " + bName + "'s volunteer status back to " + bName), (volunteer.getBorrower() == borrower ? 1 : 0) != 0);
            List<Subject> subjects = book.getSubjects();
            TestLibService.assertNotNull((String)("no subjects for the book " + qTitle), subjects);
            TestLibService.assertEquals((String)("unexpected number of subjects for the book " + qTitle), (int)2, (int)subjects.size());
        }
        catch (Exception e) {
            TestLibService.fail((String)"Unable to findBookByTitle");
        }
    }

    public void testFindBorrowerByName() {
        String bName = "Harry";
        try {
            Borrower harry = this.service.findBorrowerByName(bName);
            TestLibService.assertNotNull((String)("Could not find " + bName), (Object)harry);
            TestLibService.assertEquals((String)("the borrower found is not " + bName), (String)bName, (String)harry.getName());
        }
        catch (Exception e) {
            TestLibService.fail((String)"Unable to find borrower by name");
        }
    }

    public void testBorrowBook() {
        String bName = "Tom";
        String title = "Gone Visiting";
        try {
            Borrower borrower = this.service.findBorrowerByName(bName);
            TestLibService.assertNotNull((String)("Could not find " + bName), (Object)borrower);
            List<Book> books = borrower.getBooks();
            TestLibService.assertEquals((String)(bName + " has borrowed an unexpected number of books"), (int)1, (int)(books == null ? 0 : borrower.getBooks().size()));
            Book book = this.service.findBookByTitle(title);
            TestLibService.assertNotNull((String)("Could not find the book " + title), (Object)book);
            this.service.borrowBook(borrower, book);
            List<Book> borrowedBooks = borrower.getBooks();
            TestLibService.assertEquals((String)"Unexpected number of books borrowed", (int)2, (int)borrowedBooks.size());
            borrower = this.service.findBorrowerByName(bName);
            TestLibService.assertNotNull((String)("Could not find " + bName), (Object)borrower);
            List<Book> booksBorrowed2 = borrower.getBooks();
            TestLibService.assertEquals((String)(bName + " has borrowed an unexpected number of books"), (int)2, (int)booksBorrowed2.size());
        }
        catch (Exception e) {
            e.printStackTrace();
            TestLibService.fail((String)"Unable to borrow a book");
        }
    }

    public void testReturnBook() {
        String bName = "Harry";
        try {
            Borrower borrower = this.service.findBorrowerByName(bName);
            TestLibService.assertNotNull((String)("Could not find " + bName), (Object)borrower);
            List<Book> books = borrower.getBooks();
            TestLibService.assertEquals((String)(bName + " has borrowed an unexpected number of books"), (int)1, (int)(books == null ? 0 : borrower.getBooks().size()));
            Book book = borrower.getBooks().get(0);
            this.service.returnBook(book);
            borrower = this.service.findBorrowerByName(bName);
            TestLibService.assertNotNull((String)("Could not find " + bName), (Object)borrower);
            TestLibService.assertEquals((String)(bName + " has borrowed an unexpected number of books"), (int)0, (int)borrower.getBooks().size());
        }
        catch (Exception e) {
            e.printStackTrace();
            TestLibService.fail((String)"Unable to return a book");
        }
    }
}

