/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.spring;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.apache.openjpa.persistence.models.library.Book;
import org.apache.openjpa.persistence.models.library.Borrower;
import org.apache.openjpa.persistence.models.library.Subject;
import org.apache.openjpa.persistence.models.library.Volunteer;

public class LibTestingService {
    private EntityManager em;

    public void setEntityManager(EntityManager em) {
        this.em = em;
    }

    public void depopulateDB() {
        EntityTransaction tx = this.em.getTransaction();
        tx.begin();
        this.em.createQuery("delete from Book").executeUpdate();
        this.em.createQuery("delete from Borrower").executeUpdate();
        this.em.createQuery("delete from Subject").executeUpdate();
        tx.commit();
    }

    public void repopulateDB() {
        this.depopulateDB();
        if (!this.isDBClean()) {
            throw new IllegalStateException("Failed to clean the database");
        }
        EntityTransaction tx = null;
        try {
            tx = this.em.getTransaction();
            tx.begin();
            Borrower tom = new Borrower("Tom");
            Borrower dick = new Borrower("Dick");
            Borrower harry = new Borrower("Harry");
            this.em.persist((Object)tom);
            this.em.persist((Object)dick);
            this.em.persist((Object)harry);
            Volunteer v = new Volunteer(dick);
            v.setHoursPerWeek(10);
            Book fishing = new Book("Gone Fishing");
            Book hunting = new Book("Gone Hunting");
            Book sailing = new Book("Gone Sailing");
            Book fighting = new Book("Gone to War");
            Book visiting = new Book("Gone Visiting");
            Book working = new Book("Gone to Work");
            Book sleeping = new Book("Gone to Bed");
            this.em.persist((Object)fishing);
            this.em.persist((Object)hunting);
            this.em.persist((Object)sailing);
            this.em.persist((Object)fighting);
            this.em.persist((Object)visiting);
            this.em.persist((Object)working);
            this.em.persist((Object)sleeping);
            Subject outdoors = new Subject("Outdoors");
            Subject military = new Subject("Military");
            Subject sport = new Subject("Sportsman");
            Subject travel = new Subject("Travel");
            Subject industry = new Subject("Industry");
            Subject space = new Subject("Space");
            fishing.addSubject(outdoors);
            fishing.addSubject(sport);
            hunting.addSubject(outdoors);
            hunting.addSubject(sport);
            sailing.addSubject(outdoors);
            sailing.addSubject(travel);
            fighting.addSubject(military);
            fighting.addSubject(travel);
            visiting.addSubject(travel);
            working.addSubject(industry);
            this.em.persist((Object)space);
            tom.borrowBook(fishing);
            dick.borrowBook(hunting);
            dick.borrowBook(sailing);
            harry.borrowBook(working);
            tx.commit();
        }
        catch (RuntimeException e) {
            System.err.println("Unable to repopulate the database");
            System.err.println("Caught exception: " + e.getMessage());
            e.printStackTrace(System.err);
            throw e;
        }
        finally {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
        }
    }

    public boolean isDBClean() {
        long count = 0L;
        count += ((Long)this.em.createQuery("select count(b) from Book b").getSingleResult()).longValue();
        count += ((Long)this.em.createQuery("select count(b) from Borrower b").getSingleResult()).longValue();
        count += ((Long)this.em.createQuery("select count(v) from Volunteer v").getSingleResult()).longValue();
        return (count += ((Long)this.em.createQuery("select count(s) from Subject s").getSingleResult()).longValue()) <= 0L;
    }

    public void close() {
        if (this.em != null && this.em.isOpen()) {
            this.em.close();
        }
    }
}

