/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.simple;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import junit.textui.TestRunner;
import org.apache.openjpa.persistence.simple.AllFieldTypes;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestSerializedFactory
extends SingleEMFTestCase {
    public void setUp() {
        this.setUp(AllFieldTypes.class);
    }

    public void testSerializedEntityManagerFactory() throws Exception {
        TestSerializedFactory.assertTrue((String)"EntityManagerFactory object is not serializable", (boolean)(this.emf instanceof Serializable));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this.emf);
        EntityManagerFactory emf2 = (EntityManagerFactory)new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray())).readObject();
        TestSerializedFactory.assertTrue((String)"The deserialized entity manager factory is not open", (boolean)emf2.isOpen());
        EntityManager em = emf2.createEntityManager();
        TestSerializedFactory.assertTrue((String)"The newly created entity manager is not open", (boolean)em.isOpen());
        em.getTransaction().begin();
        em.persist((Object)new AllFieldTypes());
        em.getTransaction().commit();
        em.close();
        TestSerializedFactory.assertFalse((String)"The entity manager is not closed", (boolean)em.isOpen());
        this.clear(emf2);
        if (emf2.isOpen()) {
            emf2.close();
        }
        TestSerializedFactory.assertFalse((String)"The entity manager factory is not closed", (boolean)emf2.isOpen());
    }

    public static void main(String[] args) {
        TestRunner.run(TestSerializedFactory.class);
    }
}

