/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.simple;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.CacheRetrieveMode;
import javax.persistence.CacheStoreMode;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.simple.Item;
import org.apache.openjpa.persistence.test.SingleEMTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRefresh
extends SingleEMTestCase {
    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES, Item.class, "openjpa.AutoDetach", "commit", "openjpa.DataCache", "true", "openjpa.RemoteCommitProvider", "sjvm");
    }

    public void testFlushRefreshNewInstance() {
        this.em.getTransaction().begin();
        Item item = new Item();
        item.setItemData("Test Data");
        this.em.persist((Object)item);
        this.em.flush();
        this.em.refresh((Object)item);
        this.em.getTransaction().commit();
        TestRefresh.assertEquals((String)"Test Data", (String)item.getItemData());
    }

    public void testRefreshBypassL2Cache() {
        String original = "Original L2 Cached Data";
        String sneakUpdate = "Sneak Update";
        this.em.getTransaction().begin();
        Item item = new Item();
        item.setItemData(original);
        this.em.persist((Object)item);
        this.em.getTransaction().commit();
        this.assertCached(Item.class, item.getItemId());
        String sql = "UPDATE I_ITEM SET I_DATA=?1 WHERE I_ID=?2";
        this.em.getTransaction().begin();
        int updateCount = this.em.createNativeQuery(sql).setParameter(1, (Object)sneakUpdate).setParameter(2, (Object)item.getItemId()).executeUpdate();
        TestRefresh.assertEquals((int)1, (int)updateCount);
        this.em.getTransaction().commit();
        this.em.getTransaction().begin();
        item = (Item)this.em.find(Item.class, (Object)item.getItemId());
        TestRefresh.assertEquals((String)original, (String)item.getItemData());
        this.em.refresh((Object)item);
        TestRefresh.assertEquals((String)sneakUpdate, (String)item.getItemData());
        this.em.setProperty("javax.persistence.cache.retrieveMode", (Object)CacheRetrieveMode.USE);
        this.em.refresh((Object)item);
        TestRefresh.assertEquals((String)sneakUpdate, (String)item.getItemData());
        this.em.getTransaction().rollback();
    }

    public void testCacheRetrieveModeSetting() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.setProperty("javax.persistence.cache.retrieveMode", (Object)CacheRetrieveMode.USE);
        Map properties = em.getProperties();
        if (!properties.containsKey("javax.persistence.cache.retrieveMode")) {
            System.err.println(properties);
            TestRefresh.fail((String)"Expected javax.persistence.cache.retrieveMode properties be returned");
        }
        Object mode = properties.get("javax.persistence.cache.retrieveMode");
        TestRefresh.assertEquals(mode, (Object)CacheRetrieveMode.USE);
    }

    public void testCacheStoreModeSetting() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.setProperty("javax.persistence.cache.storeMode", (Object)CacheStoreMode.USE);
        Map properties = em.getProperties();
        if (!properties.containsKey("javax.persistence.cache.storeMode")) {
            System.err.println(properties);
            TestRefresh.fail((String)"Expected javax.persistence.cache.storeMode properties be returned");
        }
        Object mode = properties.get("javax.persistence.cache.storeMode");
        TestRefresh.assertEquals(mode, (Object)CacheStoreMode.USE);
    }

    public void testRefreshAfterRemove() {
        try {
            this.em.getTransaction().begin();
            Item item = new Item();
            item.setItemData("Test Data");
            this.em.persist((Object)item);
            this.em.flush();
            this.em.remove((Object)item);
            this.em.flush();
            this.em.refresh((Object)item);
            this.em.getTransaction().commit();
            TestRefresh.fail((String)"Did not catch expected IllegalArgumentException for refresh() of removed entity");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testFindWithCacheRetrieveProperty() {
        String key = "Test property in find.";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Item item = new Item();
        item.setItemData(key);
        em.persist((Object)item);
        em.flush();
        em.getTransaction().commit();
        int id = item.getItemId();
        em.clear();
        this.emf.getCache().evictAll();
        TestRefresh.assertEquals((String)key, (String)item.getItemData());
        em.setProperty("javax.persistence.cache.storeMode", (Object)CacheStoreMode.USE);
        em.setProperty("javax.persistence.cache.retrieveMode", (Object)CacheRetrieveMode.USE);
        Map properties = em.getProperties();
        if (!properties.containsKey("javax.persistence.cache.storeMode")) {
            System.err.println(properties);
            TestRefresh.fail((String)"Expected javax.persistence.cache.storeMode properties be returned");
        }
        if (!properties.containsKey("javax.persistence.cache.retrieveMode")) {
            System.err.println(properties);
            TestRefresh.fail((String)"Expected javax.persistence.cache.retrieveMode properties be returned");
        }
        HashMap<String, Object> paramProperties = new HashMap<String, Object>();
        paramProperties.put("javax.persistence.cache.storeMode", CacheStoreMode.BYPASS);
        paramProperties.put("javax.persistence.cache.retrieveMode", CacheRetrieveMode.BYPASS);
        Item fItem = (Item)em.find(Item.class, (Object)id, paramProperties);
        TestRefresh.assertEquals((String)fItem.getItemData(), (String)key);
        this.assertNotCached(Item.class, id);
        Object mode = em.getProperties().get("javax.persistence.cache.storeMode");
        TestRefresh.assertEquals(mode, (Object)CacheStoreMode.USE);
        mode = em.getProperties().get("javax.persistence.cache.retrieveMode");
        TestRefresh.assertEquals(mode, (Object)CacheRetrieveMode.USE);
    }

    public void testRefreshWithCacheRetrieveProperty() {
        String key = "Test property in refresh.";
        String updatedKey = "Updated test property in refresh.";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Item item = new Item();
        item.setItemData(key);
        em.persist((Object)item);
        em.flush();
        em.getTransaction().commit();
        TestRefresh.assertEquals((String)key, (String)item.getItemData());
        int id = item.getItemId();
        this.emf.getCache().evictAll();
        TestRefresh.assertEquals((String)key, (String)item.getItemData());
        em.setProperty("javax.persistence.cache.storeMode", (Object)CacheStoreMode.USE);
        em.setProperty("javax.persistence.cache.retrieveMode", (Object)CacheRetrieveMode.USE);
        Map properties = em.getProperties();
        if (!properties.containsKey("javax.persistence.cache.storeMode")) {
            System.err.println(properties);
            TestRefresh.fail((String)"Expected javax.persistence.cache.storeMode properties be returned");
        }
        if (!properties.containsKey("javax.persistence.cache.retrieveMode")) {
            System.err.println(properties);
            TestRefresh.fail((String)"Expected javax.persistence.cache.retrieveMode properties be returned");
        }
        HashMap<String, Object> paramProperties = new HashMap<String, Object>();
        paramProperties.put("javax.persistence.cache.storeMode", CacheStoreMode.BYPASS);
        paramProperties.put("javax.persistence.cache.retrieveMode", CacheRetrieveMode.BYPASS);
        Item fItem = (Item)em.find(Item.class, (Object)id, paramProperties);
        TestRefresh.assertEquals((String)key, (String)fItem.getItemData());
        this.assertNotCached(Item.class, id);
        fItem.setItemData(updatedKey);
        TestRefresh.assertEquals((String)updatedKey, (String)fItem.getItemData());
        em.refresh((Object)fItem, paramProperties);
        TestRefresh.assertEquals((String)key, (String)fItem.getItemData());
        this.assertNotCached(Item.class, id);
        Object mode = em.getProperties().get("javax.persistence.cache.storeMode");
        TestRefresh.assertEquals(mode, (Object)CacheStoreMode.USE);
        mode = em.getProperties().get("javax.persistence.cache.retrieveMode");
        TestRefresh.assertEquals(mode, (Object)CacheRetrieveMode.USE);
    }

    void assertCached(Class<?> cls, Object oid) {
        TestRefresh.assertTrue((String)(cls + ":" + oid + " should be in L2 cache, but not"), (boolean)this.emf.getCache().contains(cls, oid));
    }

    void assertNotCached(Class<?> cls, Object oid) {
        TestRefresh.assertTrue((String)(cls + ":" + oid + " should not be in L2 cache, but is"), (!this.emf.getCache().contains(cls, oid) ? 1 : 0) != 0);
    }
}

