/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.simple;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import junit.framework.TestCase;
import org.apache.openjpa.lib.conf.ProductDerivations;
import org.apache.openjpa.persistence.AutoClearType;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAPersistence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestPropertiesMethods
extends TestCase {
    private static final String UNIT_NAME = "test";
    private static OpenJPAEntityManagerFactory emf;
    private OpenJPAEntityManager em;

    public void setUp() throws Exception {
        if (emf == null) {
            HashMap<Object, Object> config = new HashMap<Object, Object>();
            config.putAll(System.getProperties());
            config.put("openjpa.DataCacheTimeout", 300);
            config.put("openjpa.AutoClear", 0);
            config.put("openjpa.Connection2Password", "xyz");
            config.put("openjpa.ProxyManager", "default(TrackChanges=false)");
            config.put("openjpa.DynamicEnhancementAgent", "false");
            emf = OpenJPAPersistence.cast((EntityManagerFactory)Persistence.createEntityManagerFactory((String)UNIT_NAME, config));
            TestPropertiesMethods.assertNotNull((Object)emf);
        }
        this.em = OpenJPAPersistence.cast((EntityManager)emf.createEntityManager());
    }

    public void testConfigurationPrefixes() {
        String[] prefixes = ProductDerivations.getConfigurationPrefixes();
        TestPropertiesMethods.assertEquals((String)"openjpa", (String)prefixes[0]);
        TestPropertiesMethods.assertTrue((boolean)Arrays.asList(prefixes).contains("javax.persistence"));
    }

    public void testEMNumericPropertyValueForEnumTypeIsReturnedAsString() {
        Map props = this.em.getProperties();
        this.assertProperty("openjpa.AutoClear", props, AutoClearType.DATASTORE);
        this.assertProperty("openjpa.IgnoreChanges", props, Boolean.FALSE);
    }

    public void testEMPluginPropertyParameterIsPreserved() {
        Map props = emf.getProperties();
        Object val = props.get("openjpa.ProxyManager");
        TestPropertiesMethods.assertNotNull(val);
        TestPropertiesMethods.assertTrue((boolean)(val instanceof String));
        String proxyManager = (String)val;
        TestPropertiesMethods.assertEquals((String)"default(TrackChanges=false)", (String)proxyManager);
    }

    public void testFactoryPropertiesContainDefaultValue() {
        Map props = emf.getProperties();
        TestPropertiesMethods.assertEquals((Object)"default", props.get("openjpa.DataCacheManager"));
        TestPropertiesMethods.assertEquals((Object)300, props.get("openjpa.DataCacheTimeout"));
    }

    public void testFactoryPropertiesContainUserSpecifiedValue() {
        Map props = emf.getProperties();
        TestPropertiesMethods.assertEquals((Object)new Integer(300), props.get("openjpa.DataCacheTimeout"));
    }

    public void testFactoryPropertiesAddPlatformOrVendor() {
        Map props = emf.getProperties();
        TestPropertiesMethods.assertTrue((boolean)props.containsKey("Platform"));
        TestPropertiesMethods.assertNotNull((Object)props.containsKey("VendorName"));
    }

    public void testFactorySupportedProperties() {
        Set props = emf.getSupportedProperties();
        TestPropertiesMethods.assertTrue((boolean)props.contains("openjpa.IgnoreChanges"));
    }

    public void testEMGetSupportedProperties() {
        Set emSupportedProperties = this.em.getSupportedProperties();
        TestPropertiesMethods.assertNotNull((Object)emSupportedProperties);
        TestPropertiesMethods.assertTrue((boolean)emSupportedProperties.contains("openjpa.AutoDetach"));
        TestPropertiesMethods.assertTrue((boolean)emSupportedProperties.contains("javax.persistence.lock.timeout"));
        TestPropertiesMethods.assertTrue((boolean)emSupportedProperties.contains("openjpa.LockTimeout"));
        TestPropertiesMethods.assertTrue((boolean)emSupportedProperties.contains("javax.persistence.query.timeout"));
        TestPropertiesMethods.assertFalse((boolean)emSupportedProperties.contains("openjpa.javax.persistence.query.timeout"));
    }

    public void testEMFPropertyValueTypeIsPreserved() {
        Map props = emf.getProperties();
        Object autoClear = props.get("openjpa.AutoClear");
        this.print("EMF Properties ", props);
        TestPropertiesMethods.assertTrue((String)("AutoClear " + autoClear + " is of " + autoClear.getClass()), (boolean)(autoClear instanceof AutoClearType));
        TestPropertiesMethods.assertEquals((Object)AutoClearType.DATASTORE, autoClear);
        Object ignoreChanges = props.get("openjpa.IgnoreChanges");
        TestPropertiesMethods.assertTrue((boolean)(ignoreChanges instanceof Boolean));
    }

    public void testEMFPluginPropertyParameterIsPreserved() {
        Map props = emf.getProperties();
        Object val = props.get("openjpa.ProxyManager");
        TestPropertiesMethods.assertNotNull(val);
        TestPropertiesMethods.assertTrue((boolean)(val instanceof String));
        String proxyManager = (String)val;
        TestPropertiesMethods.assertEquals((String)"default(TrackChanges=false)", (String)proxyManager);
    }

    public void xtestLoadKeyWithEquivalentPropertyKey() {
        Map props = emf.getProperties();
        TestPropertiesMethods.assertFalse((boolean)props.containsKey("openjpa.ConnectionURL"));
        TestPropertiesMethods.assertTrue((boolean)props.containsKey("javax.persistence.jdbc.url"));
    }

    public void xtestLoadKeyWithPrimaryPropertyKey() {
        Map props = emf.getProperties();
        TestPropertiesMethods.assertTrue((boolean)props.containsKey("openjpa.ConnectionUserName"));
        TestPropertiesMethods.assertFalse((boolean)props.containsKey("javax.persistence.jdbc.user"));
    }

    public void testPropertyValueTypeIsPreserved() {
        Map props = this.em.getProperties();
        this.assertProperty("openjpa.AutoClear", props, AutoClearType.DATASTORE);
        this.assertProperty("openjpa.IgnoreChanges", props, Boolean.FALSE);
    }

    public void testPluginPropertyParameterIsPreserved() {
        Map props = emf.getProperties();
        this.assertProperty("openjpa.ProxyManager", props, "default(TrackChanges=false)");
    }

    public void testChangePropertyValue() {
        Map props = this.em.getProperties();
        Boolean original = (Boolean)props.get("openjpa.IgnoreChanges");
        TestPropertiesMethods.assertNotNull((Object)original);
        Boolean invert = original == false;
        this.em.setIgnoreChanges(invert.booleanValue());
        this.assertProperty("openjpa.IgnoreChanges", this.em.getProperties(), invert);
    }

    public void testConfiguredPropertyValue() {
        Map props = this.em.getProperties();
        Boolean original = (Boolean)props.get("openjpa.IgnoreChanges");
        TestPropertiesMethods.assertNotNull((Object)original);
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        Boolean invert = original == false;
        config.put("openjpa.IgnoreChanges", invert);
        OpenJPAEntityManager em2 = emf.createEntityManager(config);
        this.assertProperty("openjpa.IgnoreChanges", em2.getProperties(), invert);
    }

    public void testEquivalentKeysArePresentInSupportedProperties() {
        Set keys = this.em.getSupportedProperties();
        TestPropertiesMethods.assertTrue((boolean)keys.contains("openjpa.ConnectionURL"));
        TestPropertiesMethods.assertTrue((boolean)keys.contains("javax.persistence.jdbc.url"));
    }

    public void testPasswordValuesAreInvisible() {
        Map props = this.em.getProperties();
        this.assertProperty("openjpa.Connection2Password", props, "******");
    }

    void assertProperty(String prop, Map props) {
        this.assertProperty(prop, props, null);
    }

    void assertProperty(String prop, Map props, Object expected) {
        TestPropertiesMethods.assertTrue((String)(prop + " not present"), (boolean)props.containsKey(prop));
        Object actual = props.get(prop);
        if (expected != null) {
            TestPropertiesMethods.assertTrue((String)(prop + ": Actual " + actual.getClass() + " does not match expected " + expected.getClass()), (boolean)expected.getClass().isAssignableFrom(actual.getClass()));
            TestPropertiesMethods.assertEquals((String)(prop + " value does not match"), (Object)expected, actual);
        }
    }

    void print(String message, Map<String, Object> props) {
        System.err.println(message);
        for (Map.Entry<String, Object> e : props.entrySet()) {
            System.err.println(e.getKey() + ":" + e.getValue() + " [" + (e.getValue() == null ? "" : e.getValue().getClass().getSimpleName()) + "]");
        }
    }

    void print(String message, Set<String> props) {
        System.err.println(message);
        for (String p : props) {
            System.err.println(p);
        }
    }
}

