/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.simple;

import javax.persistence.EntityTransaction;
import junit.textui.TestRunner;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.simple.AllFieldTypes;
import org.apache.openjpa.persistence.simple.Place;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestPersistence
extends SingleEMFTestCase {
    public void setUp() {
        this.setUp(AllFieldTypes.class, Place.class);
    }

    public void testCreateEntityManager() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction t = em.getTransaction();
        TestPersistence.assertNotNull((Object)t);
        t.begin();
        t.setRollbackOnly();
        t.rollback();
        TestPersistence.assertTrue((boolean)(em instanceof OpenJPAEntityManager));
        OpenJPAEntityManager ojem = (OpenJPAEntityManager)em;
        ojem.getFetchPlan().setMaxFetchDepth(1);
        TestPersistence.assertEquals((int)1, (int)ojem.getFetchPlan().getMaxFetchDepth());
        em.close();
    }

    public void testPersist() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)new AllFieldTypes());
        em.getTransaction().commit();
        em.close();
    }

    public void testQuery() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        AllFieldTypes aft = new AllFieldTypes();
        aft.setStringField("foo");
        aft.setIntField(10);
        em.persist((Object)aft);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        TestPersistence.assertEquals((int)1, (int)em.createQuery("select x from AllFieldTypes x where x.stringField = 'foo'").getResultList().size());
        TestPersistence.assertEquals((int)0, (int)em.createQuery("select x from AllFieldTypes x where x.stringField = 'bar'").getResultList().size());
        TestPersistence.assertEquals((int)1, (int)em.createQuery("select x from AllFieldTypes x where x.intField >= 10").getResultList().size());
        em.getTransaction().rollback();
        em.close();
    }

    public void testNewDeleteNew() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Place place = new Place();
        place.setLocation("Lexington");
        TestPersistence.assertFalse((boolean)em.contains((Object)place));
        em.getTransaction().begin();
        em.persist((Object)place);
        em.getTransaction().commit();
        TestPersistence.assertTrue((boolean)em.contains((Object)place));
        place = (Place)em.find(Place.class, (Object)"Lexington");
        TestPersistence.assertNotNull((Object)place);
        TestPersistence.assertEquals((String)"Lexington", (String)place.getLocation());
        em.getTransaction().begin();
        em.remove((Object)place);
        em.getTransaction().commit();
        TestPersistence.assertFalse((boolean)em.contains((Object)place));
        place = new Place();
        place.setLocation("Lexington");
        TestPersistence.assertFalse((boolean)em.contains((Object)place));
        em.getTransaction().begin();
        em.persist((Object)place);
        em.getTransaction().commit();
        TestPersistence.assertTrue((boolean)em.contains((Object)place));
        place = (Place)em.find(Place.class, (Object)"Lexington");
        TestPersistence.assertNotNull((Object)place);
        TestPersistence.assertEquals((String)"Lexington", (String)place.getLocation());
        em.close();
    }

    public static void main(String[] args) {
        TestRunner.run(TestPersistence.class);
    }
}

