/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.simple;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import junit.textui.TestRunner;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.simple.AllFieldTypes;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestBasicAnnotation
extends SingleEMFTestCase {
    public void setUp() {
        this.setUp(CLEAR_TABLES, AllFieldTypes.class);
    }

    public void testEagerFetchType() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        AllFieldTypes aft = new AllFieldTypes();
        aft.setBigDecimalField(new BigDecimal(1));
        aft.setBooleanField(false);
        aft.setByteLob(new byte[1]);
        aft.setCalendarField(Calendar.getInstance());
        aft.setDateField(new Date());
        aft.setEnumField(AllFieldTypes.EnumType.Value1);
        aft.setSerializableField(new Date());
        aft.setSqlTimestampField(new Timestamp(System.currentTimeMillis()));
        aft.setStringField("aft");
        aft.setWByteLob(new Byte[1]);
        aft.setWDoubleField(new Double(1.0));
        em.persist((Object)aft);
        em.getTransaction().commit();
        em.clear();
        AllFieldTypes aftQuery = (AllFieldTypes)em.createQuery("select x from AllFieldTypes x where x.stringField = 'aft'").getSingleResult();
        em.clear();
        TestBasicAnnotation.assertFalse((boolean)em.contains((Object)aftQuery));
        TestBasicAnnotation.assertNotNull((Object)aftQuery.getBigDecimalField());
        TestBasicAnnotation.assertNotNull((Object)aftQuery.getBooleanField());
        TestBasicAnnotation.assertNotNull((Object)aftQuery.getByteLob());
        TestBasicAnnotation.assertNotNull((Object)aftQuery.getCalendarField());
        TestBasicAnnotation.assertNotNull((Object)aftQuery.getDateField());
        TestBasicAnnotation.assertNotNull((Object)((Object)aftQuery.getEnumField()));
        TestBasicAnnotation.assertNotNull((Object)aftQuery.getSerializableField());
        TestBasicAnnotation.assertNotNull((Object)aftQuery.getSqlTimestampField());
        TestBasicAnnotation.assertNotNull((Object)aftQuery.getStringField());
        TestBasicAnnotation.assertNotNull((Object)aftQuery.getWByteLob());
        TestBasicAnnotation.assertNotNull((Object)aftQuery.getWDoubleField());
        em.close();
    }

    public static void main(String[] args) {
        TestRunner.run(TestBasicAnnotation.class);
    }
}

