/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.sequence;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.sequence.EntityEmployee;
import org.apache.openjpa.persistence.sequence.EntityPerson;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestSequence
extends SingleEMFTestCase {
    private String multiThreadExecuting = null;
    private static final int NUMBER_ENTITIES = 5000;

    public void setUp() {
        this.setUp(EntityPerson.class, EntityEmployee.class, CLEAR_TABLES, "openjpa.Multithreaded", "true");
    }

    public void tearDown() throws Exception {
    }

    public void testMultiThreadedNativeSequences() throws Exception {
        boolean supportsNativeSequence = false;
        try {
            supportsNativeSequence = ((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance().nextSequenceQuery != null;
        }
        catch (Throwable t) {
            supportsNativeSequence = false;
        }
        if (supportsNativeSequence) {
            this.mttest(6, 8);
            switch ((int)(Math.random() * 7.0)) {
                case 0: {
                    this.createAndRemove();
                    break;
                }
                case 1: {
                    this.createManyPersonsInSeparateTransactions();
                    break;
                }
                case 2: {
                    this.createManyEmployeesInSeparateTransactions();
                    break;
                }
                case 3: {
                    this.createManyPersonsAndEmployeesInSeparateTransactions();
                    break;
                }
                case 4: {
                    this.createManyPersonsInSingleTransaction();
                    break;
                }
                case 5: {
                    this.createManyEmployeesInSingleTransaction();
                    break;
                }
                case 6: {
                    this.createManyPersonsAndEmployeesInSingleTransaction();
                }
            }
        }
    }

    private void createAndRemove() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityPerson person = new EntityPerson();
        person.setFirstName("Person_First_Name");
        person.setLastName("Person_Last_Name");
        EntityEmployee employee = new EntityEmployee();
        employee.setFirstName("Employee_First_Name");
        employee.setLastName("Employee_Last_Name");
        employee.setSalary(5000.0f);
        em.getTransaction().begin();
        em.persist((Object)person);
        em.persist((Object)employee);
        em.getTransaction().commit();
        em.refresh((Object)person);
        em.refresh((Object)employee);
        int person_id = person.getId();
        int employee_id = employee.getId();
        person = (EntityPerson)em.find(EntityPerson.class, (Object)person_id);
        TestSequence.assertTrue((person != null ? 1 : 0) != 0);
        TestSequence.assertTrue((person.getId() == person_id ? 1 : 0) != 0);
        TestSequence.assertTrue((boolean)person.getFirstName().equals("Person_First_Name"));
        TestSequence.assertTrue((boolean)person.getLastName().equals("Person_Last_Name"));
        employee = (EntityEmployee)em.find(EntityEmployee.class, (Object)employee_id);
        TestSequence.assertTrue((employee != null ? 1 : 0) != 0);
        TestSequence.assertTrue((employee.getId() == employee_id ? 1 : 0) != 0);
        TestSequence.assertTrue((boolean)employee.getFirstName().equals("Employee_First_Name"));
        TestSequence.assertTrue((boolean)employee.getLastName().equals("Employee_Last_Name"));
        TestSequence.assertTrue((employee.getSalary() == 5000.0f ? 1 : 0) != 0);
        em.getTransaction().begin();
        em.remove((Object)person);
        em.remove((Object)employee);
        em.getTransaction().commit();
        em.clear();
        em.close();
    }

    private void createManyPersonsInSeparateTransactions() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        for (int ii = 0; ii < 5000; ++ii) {
            EntityPerson person = new EntityPerson();
            person.setFirstName("1_First_name_" + ii);
            person.setLastName("1_Last_name_" + ii);
            em.getTransaction().begin();
            em.persist((Object)person);
            em.getTransaction().commit();
        }
        em.clear();
        em.close();
    }

    private void createManyEmployeesInSeparateTransactions() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        for (int ii = 0; ii < 5000; ++ii) {
            EntityEmployee employee = new EntityEmployee();
            employee.setFirstName("2_First_name_" + ii);
            employee.setLastName("2_Last_name_" + ii);
            employee.setSalary(ii);
            em.getTransaction().begin();
            em.persist((Object)employee);
            em.getTransaction().commit();
        }
        em.clear();
        em.close();
    }

    private void createManyPersonsAndEmployeesInSeparateTransactions() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        for (int ii = 0; ii < 5000; ++ii) {
            EntityPerson person = new EntityPerson();
            person.setFirstName("3_First_name_" + ii);
            person.setLastName("3_Last_name_" + ii);
            EntityEmployee employee = new EntityEmployee();
            employee.setFirstName("4_First_name_" + ii);
            employee.setLastName("4_Last_name_" + ii);
            employee.setSalary(ii);
            em.getTransaction().begin();
            em.persist((Object)person);
            em.persist((Object)employee);
            em.getTransaction().commit();
        }
        em.clear();
        em.close();
    }

    private void createManyPersonsInSingleTransaction() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        for (int ii = 0; ii < 5000; ++ii) {
            EntityPerson person = new EntityPerson();
            person.setFirstName("5_First_name_" + ii);
            person.setLastName("5_Last_name_" + ii);
            em.persist((Object)person);
        }
        em.getTransaction().commit();
        em.clear();
        em.close();
    }

    private void createManyEmployeesInSingleTransaction() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        for (int ii = 0; ii < 5000; ++ii) {
            EntityEmployee employee = new EntityEmployee();
            employee.setFirstName("6_First_name_" + ii);
            employee.setLastName("6_Last_name_" + ii);
            employee.setSalary(ii);
            em.persist((Object)employee);
        }
        em.getTransaction().commit();
        em.clear();
        em.close();
    }

    private void createManyPersonsAndEmployeesInSingleTransaction() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        for (int ii = 0; ii < 5000; ++ii) {
            EntityPerson person = new EntityPerson();
            person.setFirstName("7_First_name_" + ii);
            person.setLastName("7_Last_name_" + ii);
            EntityEmployee employee = new EntityEmployee();
            employee.setFirstName("8_First_name_" + ii);
            employee.setLastName("8_Last_name_" + ii);
            employee.setSalary(ii);
            em.persist((Object)person);
            em.persist((Object)employee);
        }
        em.getTransaction().commit();
        em.clear();
        em.close();
    }

    public void mttest() throws ThreadingException {
        int iterations = 6;
        int threads = 8;
        this.mttest(threads, iterations);
    }

    public void mttest(int threads, int iterations) {
        this.mttest(0, threads, iterations);
    }

    public void mttest(int serialCount, int threads, int iterations) throws ThreadingException {
        String methodName = this.callingMethod("mttest");
        this.mttest(serialCount, threads, iterations, methodName, new Object[0]);
    }

    public void mttest(int threads, int iterations, String method, Object[] args) throws ThreadingException {
        this.mttest(0, threads, iterations, method, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mttest(int serialCount, int threads, int iterations, String method, Object[] args) throws ThreadingException {
        if (this.multiThreadExecuting != null && this.multiThreadExecuting.equals(method)) {
            return;
        }
        this.multiThreadExecuting = method;
        try {
            Method meth;
            Class[] paramClasses = new Class[args.length];
            for (int i = 0; i < paramClasses.length; ++i) {
                paramClasses[i] = args[i].getClass();
            }
            try {
                meth = ((Object)((Object)this)).getClass().getMethod(method, paramClasses);
            }
            catch (NoSuchMethodException nsme) {
                throw new ThreadingException(nsme.toString(), nsme);
            }
            TestSequence thiz = this;
            this.mttest("reflection invocation: (" + method + ")", serialCount, threads, iterations, new VolatileRunnable((Object)thiz, args){
                final /* synthetic */ Object val$thiz;
                final /* synthetic */ Object[] val$args;
                {
                    this.val$thiz = object;
                    this.val$args = objectArray;
                }

                public void run() throws Exception {
                    meth.invoke(this.val$thiz, this.val$args);
                }
            });
        }
        finally {
            this.multiThreadExecuting = null;
        }
    }

    public void mttest(String title, int threads, int iterations, VolatileRunnable runner) throws ThreadingException {
        this.mttest(title, 0, threads, iterations, runner);
    }

    public void mttest(String title, int serialCount, final int threads, final int iterations, final VolatileRunnable runner) throws ThreadingException {
        int i;
        final List exceptions = Collections.synchronizedList(new LinkedList());
        Thread[] runners = new Thread[threads];
        final long startMillis = System.currentTimeMillis() + 1000L;
        for (i = 1; i <= threads; ++i) {
            final int thisThread = i;
            runners[i - 1] = new Thread(title + " [" + i + " of " + threads + "]"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    int thisIteration;
                    while (System.currentTimeMillis() < startMillis) {
                        2.yield();
                    }
                    try {
                        for (thisIteration = 1; thisIteration <= iterations; ++thisIteration) {
                            runner.run();
                        }
                    }
                    catch (Throwable error) {
                        List list = exceptions;
                        synchronized (list) {
                            exceptions.add(new ThreadingException("thread=" + this.toString() + ";threadNum=" + thisThread + ";maxThreads=" + threads + ";iteration=" + thisIteration + ";maxIterations=" + iterations, error));
                        }
                    }
                }
            };
        }
        for (i = 0; i < serialCount; ++i) {
            runners[0].run();
        }
        for (i = 0; i < threads; ++i) {
            runners[i].start();
        }
        for (i = 0; i < threads; ++i) {
            try {
                runners[i].join();
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (exceptions.size() == 0) {
            return;
        }
        Throwable[] errors = exceptions.toArray(new Throwable[0]);
        throw new ThreadingException("The " + errors.length + " embedded errors " + "occured in the execution of " + iterations + " iterations " + "of " + threads + " threads: [" + title + "]", errors);
    }

    public boolean isRootThread() {
        return this.multiThreadExecuting == null;
    }

    public String callingMethod(String exclude) {
        StringWriter sw = new StringWriter();
        new Exception().printStackTrace(new PrintWriter(sw));
        StringTokenizer stackTrace = new StringTokenizer(sw.toString(), System.getProperty("line.separator"));
        while (stackTrace.hasMoreTokens()) {
            String fullMethodName;
            String shortMethodName;
            String line = stackTrace.nextToken().trim();
            if (!line.startsWith("at ") || (shortMethodName = (fullMethodName = line.substring(0, line.indexOf("("))).substring(fullMethodName.lastIndexOf(".") + 1)).equals("callingMethod") || exclude != null && shortMethodName.equals(exclude)) continue;
            return shortMethodName;
        }
        throw new IllegalStateException("Could not identify calling method in stack trace");
    }

    public class ThreadingException
    extends RuntimeException {
        private static final long serialVersionUID = -1911769845552507956L;
        private final Throwable[] _nested;

        public ThreadingException(String msg, Throwable nested) {
            super(msg);
            this._nested = nested == null ? new Throwable[0] : new Throwable[]{nested};
        }

        public ThreadingException(String msg, Throwable[] nested) {
            super(msg);
            this._nested = nested == null ? new Throwable[0] : nested;
        }

        public void printStackTrace() {
            this.printStackTrace(System.out);
        }

        public void printStackTrace(PrintStream out) {
            this.printStackTrace(new PrintWriter(out));
        }

        public void printStackTrace(PrintWriter out) {
            super.printStackTrace(out);
            for (int i = 0; i < this._nested.length; ++i) {
                out.print("Nested Throwable #" + (i + 1) + ": ");
                this._nested[i].printStackTrace(out);
            }
        }
    }

    public static interface VolatileRunnable {
        public void run() throws Exception;
    }
}

