/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.relations;

import java.util.HashMap;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.relations.MapKeyChild;
import org.apache.openjpa.persistence.relations.MapKeyParent;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestParallelEagerMap
extends SingleEMFTestCase {
    public void setUp() {
        super.setUp(CLEAR_TABLES, MapKeyParent.class, MapKeyChild.class, "openjpa.jdbc.EagerFetchMode", "parallel");
    }

    public void testParentNotNull() {
        MapKeyParent[] parents;
        for (MapKeyParent parent : parents = new MapKeyParent[]{new MapKeyParent(), new MapKeyParent()}) {
            HashMap<String, MapKeyChild> children = new HashMap<String, MapKeyChild>();
            for (String key : new String[]{"childA"}) {
                MapKeyChild child = new MapKeyChild();
                child.setParent(parent);
                child.setMapKey(key);
                children.put(key, child);
            }
            parent.setChildren(children);
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        for (MapKeyParent parent : parents) {
            em.persist((Object)parent);
        }
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        MapKeyParent parent2 = (MapKeyParent)em.createQuery("SELECT p FROM MapKeyParent p WHERE p.id=" + parents[0].getId() + " OR p.id=" + parents[1].getId()).getResultList().get(1);
        em.close();
        for (MapKeyChild child : parent2.getChildren().values()) {
            TestParallelEagerMap.assertNotNull((String)"Parent should not be null", (Object)child.getParent());
        }
    }
}

