/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.relations;

import java.util.Collection;
import junit.textui.TestRunner;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.relations.Util1xmLf;
import org.apache.openjpa.persistence.relations.Util1xmRt;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestOneToManyWithEagerLazyFetch
extends SingleEMFTestCase {
    final int TestUtil1xm_TestRow_Id = 100;

    public void setUp() {
        this.setUp(Util1xmLf.class, Util1xmRt.class);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Util1xmLf lf1xm = new Util1xmLf();
        lf1xm.setId(100);
        lf1xm.setFirstName("loaded firstName");
        Util1xmRt rt1xm1 = new Util1xmRt();
        rt1xm1.setId(111);
        rt1xm1.setLastName("loaded lastName1");
        lf1xm.addUniRightLzy(rt1xm1);
        Util1xmRt rt1xm2 = new Util1xmRt();
        rt1xm2.setId(112);
        rt1xm2.setLastName("loaded lastName2");
        lf1xm.addUniRightLzy(rt1xm2);
        Util1xmRt rt1xm3 = new Util1xmRt();
        rt1xm3.setId(121);
        rt1xm3.setLastName("loaded eager lastName3");
        lf1xm.addUniRightEgr(rt1xm3);
        Util1xmRt rt1xm4 = new Util1xmRt();
        rt1xm4.setId(122);
        rt1xm4.setLastName("loaded eager lastName4");
        lf1xm.addUniRightEgr(rt1xm4);
        em.persist((Object)rt1xm1);
        em.persist((Object)rt1xm2);
        em.persist((Object)rt1xm3);
        em.persist((Object)rt1xm4);
        em.persist((Object)lf1xm);
        em.getTransaction().commit();
        em.close();
    }

    public void testLoadedOneToManyCount() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Util1xmLf e1 = (Util1xmLf)em.find(Util1xmLf.class, (Object)100);
        TestOneToManyWithEagerLazyFetch.assertNotNull((String)"Found Util1xmLf(id=100)", (Object)e1);
        Collection<Util1xmRt> eRs = e1.getUniRightLzy();
        TestOneToManyWithEagerLazyFetch.assertNotNull((String)"Util1xmRt uniRightLzy != null", eRs);
        TestOneToManyWithEagerLazyFetch.assertEquals((String)"Util1xmRt uniRightLzy.size == 2", (int)eRs.size(), (int)2);
        Collection<Util1xmRt> eEs = e1.getUniRightEgr();
        TestOneToManyWithEagerLazyFetch.assertNotNull((String)"Util1xmRt uniRightEgr != null", eEs);
        TestOneToManyWithEagerLazyFetch.assertEquals((String)"Util1xmRt uniRightEgr.size == 2", (int)eEs.size(), (int)2);
        em.close();
    }

    public static void main(String[] args) {
        TestRunner.run(TestOneToManyWithEagerLazyFetch.class);
    }
}

