/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.relations;

import java.util.List;
import junit.textui.TestRunner;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.relations.BidiChild;
import org.apache.openjpa.persistence.relations.BidiParent;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestOneOneNulls
extends SingleEMFTestCase {
    private long pid1;
    private long pid2;
    private long cid1;
    private long cid2;

    public void setUp() {
        this.setUp(BidiParent.class, BidiChild.class, CLEAR_TABLES);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        for (int i = 1; i <= 2; ++i) {
            BidiParent parent = new BidiParent();
            parent.setName("parent" + i);
            em.persist((Object)parent);
            BidiChild child = new BidiChild();
            child.setName("child" + i);
            if (i == 2) {
                child.setOneToOneParent(null);
                parent.setOneToOneChild(null);
            }
            em.persist((Object)child);
            if (i == 1) {
                this.pid1 = parent.getId();
                this.cid1 = child.getId();
                continue;
            }
            this.pid2 = parent.getId();
            this.cid2 = child.getId();
        }
        em.getTransaction().commit();
        em.close();
    }

    public void testFindOneToOneNullDefaults() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getFetchPlan().addField(BidiParent.class, "oneToOneChild");
        em.getFetchPlan().addField(BidiChild.class, "oneToOneParent");
        BidiParent parent = (BidiParent)em.find(BidiParent.class, (Object)this.pid1);
        TestOneOneNulls.assertEquals((String)"parent1", (String)parent.getName());
        TestOneOneNulls.assertNull((Object)parent.getOneToOneChild());
        BidiChild child = (BidiChild)em.find(BidiChild.class, (Object)this.cid1);
        TestOneOneNulls.assertEquals((String)"child1", (String)child.getName());
        TestOneOneNulls.assertNull((Object)child.getOneToOneParent());
        em.close();
    }

    public void testFindOneToOneNullExplicit() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getFetchPlan().addField(BidiParent.class, "oneToOneChild");
        em.getFetchPlan().addField(BidiChild.class, "oneToOneParent");
        BidiParent parent = (BidiParent)em.find(BidiParent.class, (Object)this.pid2);
        TestOneOneNulls.assertEquals((String)"parent2", (String)parent.getName());
        TestOneOneNulls.assertNull((Object)parent.getOneToOneChild());
        BidiChild child = (BidiChild)em.find(BidiChild.class, (Object)this.cid2);
        TestOneOneNulls.assertEquals((String)"child2", (String)child.getName());
        TestOneOneNulls.assertNull((Object)child.getOneToOneParent());
        em.close();
    }

    public void testQueryOneToOneNullChild() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAQuery q = em.createQuery("SELECT o FROM BidiParent o ORDER BY o.name ASC");
        q.getFetchPlan().addField(BidiParent.class, "oneToOneChild");
        q.getFetchPlan().addField(BidiChild.class, "oneToOneParent");
        List res = q.getResultList();
        TestOneOneNulls.assertEquals((int)2, (int)res.size());
        for (int i = 0; i < res.size(); ++i) {
            TestOneOneNulls.assertEquals((String)("parent" + (i + 1)), (String)((BidiParent)res.get(i)).getName());
            TestOneOneNulls.assertNull((Object)((BidiParent)res.get(i)).getOneToOneChild());
        }
        em.close();
    }

    public void testQueryOneToOneNullParent() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAQuery q = em.createQuery("SELECT o FROM BidiChild o ORDER BY o.name ASC");
        q.getFetchPlan().addField(BidiParent.class, "oneToOneChild");
        q.getFetchPlan().addField(BidiChild.class, "oneToOneParent");
        List res = q.getResultList();
        TestOneOneNulls.assertEquals((int)2, (int)res.size());
        for (int i = 0; i < res.size(); ++i) {
            TestOneOneNulls.assertEquals((String)("child" + (i + 1)), (String)((BidiChild)res.get(i)).getName());
            TestOneOneNulls.assertNull((Object)((BidiChild)res.get(i)).getOneToOneParent());
        }
        em.close();
    }

    public static void main(String[] args) {
        TestRunner.run(TestOneOneNulls.class);
    }
}

