/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.relations;

import javax.persistence.EntityManager;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.strats.HandlerFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.MaxEmbeddedBlobFieldStrategy;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.relations.HandlerToHandlerMapInstance;
import org.apache.openjpa.persistence.test.SingleEMTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestMapCollectionToBlob
extends SingleEMTestCase {
    @Override
    public void setUp() {
        this.setUp(HandlerToHandlerMapInstance.class, CLEAR_TABLES, "openjpa.Compatibility", "StoreMapCollectionInEntityAsBlob=true");
    }

    public void testHandlerToHandlerMaps() {
        ClassMapping cm = (ClassMapping)JPAFacadeHelper.getMetaData((EntityManager)this.em, HandlerToHandlerMapInstance.class);
        FieldMapping fm = cm.getFieldMapping("map");
        TestMapCollectionToBlob.assertEquals(this.getBlobFieldStrategy(), fm.getStrategy().getClass());
        TestMapCollectionToBlob.assertEquals((String)"NONSTD_MAPPING_MAP", (String)fm.getTable().getName());
        TestMapCollectionToBlob.assertEquals((int)fm.getTable().getColumn("MAP").getType(), (int)2004);
        HandlerToHandlerMapInstance o = new HandlerToHandlerMapInstance();
        o.getMap().put("foo", "bar");
        this.em.getTransaction().begin();
        this.em.persist((Object)o);
        this.em.getTransaction().commit();
        this.em.close();
    }

    private Class<?> getBlobFieldStrategy() {
        DBDictionary dict = ((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance();
        if (dict.maxEmbeddedBlobSize == -1) {
            return HandlerFieldStrategy.class;
        }
        return MaxEmbeddedBlobFieldStrategy.class;
    }
}

