/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.relations;

import java.util.List;
import junit.textui.TestRunner;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.relations.OneManyEagerChild;
import org.apache.openjpa.persistence.relations.OneManyEagerParent;
import org.apache.openjpa.persistence.relations.OneManyLazyChild;
import org.apache.openjpa.persistence.relations.OneOneChild;
import org.apache.openjpa.persistence.relations.OneOneParent;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestManyEagerSQL
extends SQLListenerTestCase {
    public void setUp() {
        Object parent;
        this.setUp(DROP_TABLES, OneManyEagerParent.class, OneManyEagerChild.class, OneManyLazyChild.class, OneOneParent.class, OneOneChild.class);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        for (int j = 0; j < 2; ++j) {
            parent = new OneManyEagerParent();
            ((OneManyEagerParent)parent).setName("parent" + j);
            for (int i = 0; i < 2; ++i) {
                OneManyEagerChild child = new OneManyEagerChild();
                child.setName("eagerchild" + i);
                ((OneManyEagerParent)parent).addEagerChild(child);
                em.persist((Object)child);
                OneManyLazyChild lazychild = new OneManyLazyChild();
                lazychild.setName("lazychild" + i);
                ((OneManyEagerParent)parent).addLazyChild(lazychild);
                em.persist((Object)lazychild);
            }
            em.persist(parent);
        }
        for (int i = 0; i < 3; ++i) {
            parent = new OneOneParent();
            ((OneOneParent)parent).setName("parent" + i);
            OneOneChild child = new OneOneChild();
            child.setName("child" + i);
            ((OneOneParent)parent).setChild(child);
            child.setParent((OneOneParent)parent);
            em.persist((Object)child);
            em.persist(parent);
        }
        em.flush();
        em.getTransaction().commit();
        em.close();
    }

    public void testManyToOneEagerQuery() {
        this.sql.clear();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String query = "select c FROM OneManyEagerChild c";
        OpenJPAQuery q = em.createQuery(query);
        List list = q.getResultList();
        TestManyEagerSQL.assertEquals((int)4, (int)list.size());
        TestManyEagerSQL.assertEquals((int)5, (int)this.sql.size());
        this.sql.clear();
        for (int i = 0; i < list.size(); ++i) {
            OneManyEagerChild child = (OneManyEagerChild)list.get(i);
            TestManyEagerSQL.assertEquals((int)2, (int)child.getParent().getLazyChildren().size());
            TestManyEagerSQL.assertEquals((int)2, (int)child.getParent().getEagerChildren().size());
        }
        TestManyEagerSQL.assertEquals((int)0, (int)this.sql.size());
        em.close();
    }

    public void testManyToOneLazyQuery() {
        this.sql.clear();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String query = "select c FROM OneManyLazyChild c";
        OpenJPAQuery q = em.createQuery(query);
        List list = q.getResultList();
        TestManyEagerSQL.assertEquals((int)4, (int)list.size());
        TestManyEagerSQL.assertEquals((int)1, (int)this.sql.size());
        this.sql.clear();
        for (int i = 0; i < list.size(); ++i) {
            OneManyLazyChild child = (OneManyLazyChild)list.get(i);
            TestManyEagerSQL.assertEquals((int)2, (int)child.getParent().getLazyChildren().size());
            TestManyEagerSQL.assertEquals((int)2, (int)child.getParent().getEagerChildren().size());
        }
        TestManyEagerSQL.assertEquals((int)4, (int)this.sql.size());
        em.close();
    }

    public void testOneToManyEagerQuery() {
        this.sql.clear();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String query = "select p FROM OneManyEagerParent p";
        OpenJPAQuery q = em.createQuery(query);
        List list = q.getResultList();
        TestManyEagerSQL.assertEquals((int)2, (int)list.size());
        TestManyEagerSQL.assertEquals((int)3, (int)this.sql.size());
        this.sql.clear();
        for (int i = 0; i < list.size(); ++i) {
            OneManyEagerParent p = (OneManyEagerParent)list.get(i);
            long id = p.getId();
            TestManyEagerSQL.assertEquals((int)2, (int)p.getEagerChildren().size());
            TestManyEagerSQL.assertEquals((Object)p, (Object)p.getEagerChildren().get(0).getParent());
            TestManyEagerSQL.assertEquals((Object)p, (Object)p.getEagerChildren().get(1).getParent());
            TestManyEagerSQL.assertEquals((long)id, (long)p.getEagerChildren().get(0).getParent().getId());
            TestManyEagerSQL.assertEquals((long)id, (long)p.getEagerChildren().get(1).getParent().getId());
            TestManyEagerSQL.assertEquals((String)"eagerchild0", (String)p.getEagerChildren().get(0).getName());
            TestManyEagerSQL.assertEquals((String)"eagerchild1", (String)p.getEagerChildren().get(1).getName());
            TestManyEagerSQL.assertEquals((int)2, (int)p.getLazyChildren().size());
            TestManyEagerSQL.assertEquals((Object)p, (Object)p.getLazyChildren().get(0).getParent());
            TestManyEagerSQL.assertEquals((Object)p, (Object)p.getLazyChildren().get(1).getParent());
            TestManyEagerSQL.assertEquals((long)id, (long)p.getLazyChildren().get(0).getParent().getId());
            TestManyEagerSQL.assertEquals((long)id, (long)p.getLazyChildren().get(1).getParent().getId());
            TestManyEagerSQL.assertEquals((String)"lazychild0", (String)p.getLazyChildren().get(0).getName());
            TestManyEagerSQL.assertEquals((String)"lazychild1", (String)p.getLazyChildren().get(1).getName());
        }
        TestManyEagerSQL.assertEquals((int)0, (int)this.sql.size());
        em.close();
    }

    public void testOneToOneParentQuery() {
        this.sql.clear();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String query = "select p FROM OneOneParent p";
        OpenJPAQuery q = em.createQuery(query);
        List list = q.getResultList();
        TestManyEagerSQL.assertEquals((int)3, (int)list.size());
        TestManyEagerSQL.assertEquals((int)1, (int)this.sql.size());
        this.sql.clear();
        for (int i = 0; i < list.size(); ++i) {
            OneOneParent p = (OneOneParent)list.get(i);
            TestManyEagerSQL.assertEquals((Object)p, (Object)p.getChild().getParent());
        }
        TestManyEagerSQL.assertEquals((int)0, (int)this.sql.size());
        em.close();
    }

    public void testOneToOneChildQuery() {
        this.sql.clear();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String query = "select c FROM OneOneChild c";
        OpenJPAQuery q = em.createQuery(query);
        List list = q.getResultList();
        TestManyEagerSQL.assertEquals((int)3, (int)list.size());
        TestManyEagerSQL.assertEquals((int)1, (int)this.sql.size());
        this.sql.clear();
        for (int i = 0; i < list.size(); ++i) {
            OneOneChild c = (OneOneChild)list.get(i);
            TestManyEagerSQL.assertEquals((Object)c, (Object)c.getParent().getChild());
        }
        TestManyEagerSQL.assertEquals((int)0, (int)this.sql.size());
        em.close();
    }

    public static void main(String[] args) {
        TestRunner.run(TestManyEagerSQL.class);
    }
}

