/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.relations;

import org.apache.openjpa.enhance.DynamicPersistenceCapable;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.relations.BasicEntity;
import org.apache.openjpa.persistence.relations.UnidirectionalManyToOne;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestLazyManyToOne
extends SQLListenerTestCase {
    private int id;

    public void setUp() {
        this.setUp(BasicEntity.class, UnidirectionalManyToOne.class, CLEAR_TABLES);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        UnidirectionalManyToOne pc = new UnidirectionalManyToOne();
        pc.setRelated(new BasicEntity());
        pc.getRelated().setName("foo");
        em.persist((Object)pc);
        em.getTransaction().commit();
        this.id = pc.getId();
        em.close();
        this.sql.clear();
    }

    public void testLazyManyToOne() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        UnidirectionalManyToOne pc = (UnidirectionalManyToOne)em.find(UnidirectionalManyToOne.class, (Object)this.id);
        if (pc instanceof PersistenceCapable && !(pc instanceof DynamicPersistenceCapable)) {
            TestLazyManyToOne.assertEquals((int)1, (int)this.sql.size());
        }
        TestLazyManyToOne.assertNotNull((Object)pc.getRelated());
        if (pc instanceof PersistenceCapable && !(pc instanceof DynamicPersistenceCapable)) {
            TestLazyManyToOne.assertEquals((int)2, (int)this.sql.size());
        }
        em.close();
    }
}

