/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.relations;

import java.util.Iterator;
import junit.textui.TestRunner;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.relations.BasicEntity;
import org.apache.openjpa.persistence.relations.LRSEntity;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestLRS
extends SingleEMFTestCase {
    private long id;

    public void setUp() {
        this.setUp(LRSEntity.class, BasicEntity.class, CLEAR_TABLES, "openjpa.Compatibility", "default(copyOnDetach=true,cascadeWithDetach=true)");
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        LRSEntity lrs = new LRSEntity();
        lrs.setName("lrs");
        for (int i = 1; i <= 3; ++i) {
            BasicEntity basic = new BasicEntity();
            basic.setName("basic" + i);
            em.persist((Object)basic);
            lrs.getLRSList().add(basic);
        }
        em.persist((Object)lrs);
        em.getTransaction().commit();
        this.id = lrs.getId();
        em.close();
    }

    public void testEMClear() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        LRSEntity lrs = (LRSEntity)em.find(LRSEntity.class, (Object)this.id);
        this.assertLRS(lrs, "lrs");
        em.clear();
        TestLRS.assertNull(lrs.getLRSList());
        this.assertMerge(lrs);
        em.close();
    }

    public void testEMClose() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        LRSEntity lrs = (LRSEntity)em.find(LRSEntity.class, (Object)this.id);
        this.assertLRS(lrs, "lrs");
        em.close();
        TestLRS.assertNull(lrs.getLRSList());
        this.assertMerge(lrs);
    }

    public void testDetachCopy() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        LRSEntity lrs = (LRSEntity)em.find(LRSEntity.class, (Object)this.id);
        this.assertLRS(lrs, "lrs");
        lrs = (LRSEntity)em.detachCopy((Object)lrs);
        TestLRS.assertEquals((String)"lrs", (String)lrs.getName());
        TestLRS.assertNull(lrs.getLRSList());
        em.close();
        this.assertMerge(lrs);
    }

    private void assertLRS(LRSEntity lrs, String name) {
        TestLRS.assertNotNull((Object)lrs);
        TestLRS.assertEquals((String)name, (String)lrs.getName());
        TestLRS.assertEquals((int)3, (int)lrs.getLRSList().size());
        Iterator<BasicEntity> itr = lrs.getLRSList().iterator();
        int i = 1;
        while (itr.hasNext()) {
            BasicEntity basic = itr.next();
            TestLRS.assertEquals((String)("basic" + i), (String)basic.getName());
            ++i;
        }
        OpenJPAPersistence.close(itr);
    }

    private void assertMerge(LRSEntity lrs) {
        lrs.setName("changed");
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        this.assertLRS((LRSEntity)em.merge((Object)lrs), "changed");
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        this.assertLRS((LRSEntity)em.find(LRSEntity.class, (Object)this.id), "changed");
        em.close();
    }

    public static void main(String[] args) {
        TestRunner.run(TestLRS.class);
    }
}

