/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.relations;

import javax.persistence.EntityManager;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.strats.HandlerHandlerMapTableFieldStrategy;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.relations.HandlerToHandlerMapInstance;
import org.apache.openjpa.persistence.test.SingleEMTestCase;

public class TestHandlerToHandlerMaps
extends SingleEMTestCase {
    public void setUp() {
        this.setUp(HandlerToHandlerMapInstance.class, CLEAR_TABLES);
    }

    public void testHandlerToHandlerMaps() {
        ClassMapping cm = (ClassMapping)JPAFacadeHelper.getMetaData((EntityManager)this.em, HandlerToHandlerMapInstance.class);
        FieldMapping fm = cm.getFieldMapping("map");
        TestHandlerToHandlerMaps.assertEquals(HandlerHandlerMapTableFieldStrategy.class, fm.getStrategy().getClass());
        TestHandlerToHandlerMaps.assertEquals((String)"NONSTD_MAPPING_MAP", (String)fm.getTable().getName());
        HandlerToHandlerMapInstance o = new HandlerToHandlerMapInstance();
        o.getMap().put("foo", "bar");
        this.em.getTransaction().begin();
        this.em.persist((Object)o);
        this.em.getTransaction().commit();
        this.em.close();
    }
}

