/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.relations;

import java.util.List;
import junit.textui.TestRunner;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.OracleDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.relations.BidiChild;
import org.apache.openjpa.persistence.relations.BidiParent;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestEagerBidiSQL
extends SQLListenerTestCase {
    private long id1;
    private long id2;

    public void setUp() {
        this.setUp(BidiParent.class, BidiChild.class);
        DBDictionary dict = ((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance();
        if (dict instanceof OracleDictionary) {
            dict.setJoinSyntax("sql92");
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        for (int i = 1; i <= 2; ++i) {
            BidiParent parent = new BidiParent();
            parent.setName("parent" + i);
            em.persist((Object)parent);
            BidiChild oneOneChild = new BidiChild();
            oneOneChild.setName("oneToOneChild" + i);
            oneOneChild.setOneToOneParent(parent);
            parent.setOneToOneChild(oneOneChild);
            em.persist((Object)oneOneChild);
            for (int j = 1; j <= 3; ++j) {
                BidiChild oneManyChild = new BidiChild();
                oneManyChild.setName("oneToManyChild" + i + "::" + j);
                oneManyChild.setOneToManyParent(parent);
                parent.getOneToManyChildren().add(oneManyChild);
                em.persist((Object)oneManyChild);
            }
            if (i == 1) {
                this.id1 = parent.getId();
                continue;
            }
            this.id2 = parent.getId();
        }
        em.getTransaction().commit();
        em.close();
    }

    public void testEagerOwnerOneToManyFind() {
        this.sql.clear();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getFetchPlan().addField(BidiParent.class, "oneToManyChildren");
        em.getFetchPlan().addField(BidiChild.class, "oneToManyParent");
        BidiParent parent = (BidiParent)em.find(BidiParent.class, (Object)this.id1);
        TestEagerBidiSQL.assertEquals((int)1, (int)this.sql.size());
        this.assertNotSQL(".* LEFT OUTER JOIN BidiParent .*");
        TestEagerBidiSQL.assertEquals((String)"parent1", (String)parent.getName());
        TestEagerBidiSQL.assertEquals((int)3, (int)parent.getOneToManyChildren().size());
        for (int i = 0; i < 3; ++i) {
            TestEagerBidiSQL.assertEquals((String)("oneToManyChild1::" + (i + 1)), (String)parent.getOneToManyChildren().get(i).getName());
            TestEagerBidiSQL.assertEquals((Object)parent, (Object)parent.getOneToManyChildren().get(i).getOneToManyParent());
        }
        TestEagerBidiSQL.assertEquals((int)1, (int)this.sql.size());
        em.close();
    }

    public void testEagerOwnerOneToOneFind() {
        this.sql.clear();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getFetchPlan().addField(BidiParent.class, "oneToOneChild");
        em.getFetchPlan().addField(BidiChild.class, "oneToOneParent");
        BidiParent parent = (BidiParent)em.find(BidiParent.class, (Object)this.id1);
        TestEagerBidiSQL.assertEquals((int)1, (int)this.sql.size());
        this.assertNotSQL(".* LEFT OUTER JOIN BidiParent .*");
        TestEagerBidiSQL.assertEquals((String)"parent1", (String)parent.getName());
        TestEagerBidiSQL.assertNotNull((Object)parent.getOneToOneChild());
        TestEagerBidiSQL.assertEquals((String)"oneToOneChild1", (String)parent.getOneToOneChild().getName());
        TestEagerBidiSQL.assertEquals((Object)parent, (Object)parent.getOneToOneChild().getOneToOneParent());
        TestEagerBidiSQL.assertEquals((int)1, (int)this.sql.size());
        em.close();
    }

    public void testEagerOwnerOneToManyQuery() {
        this.sql.clear();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAQuery q = em.createQuery("SELECT o FROM BidiParent o ORDER BY o.name ASC");
        q.getFetchPlan().addField(BidiParent.class, "oneToManyChildren");
        q.getFetchPlan().addField(BidiChild.class, "oneToManyParent");
        List res = q.getResultList();
        TestEagerBidiSQL.assertEquals((int)2, (int)res.size());
        TestEagerBidiSQL.assertEquals((String)this.sql.toString(), (int)2, (int)this.sql.size());
        this.assertNotSQL(".* LEFT OUTER JOIN BidiParent .*");
        for (int i = 0; i < res.size(); ++i) {
            TestEagerBidiSQL.assertEquals((String)("parent" + (i + 1)), (String)((BidiParent)res.get(i)).getName());
            TestEagerBidiSQL.assertEquals((int)3, (int)((BidiParent)res.get(i)).getOneToManyChildren().size());
            for (int j = 0; j < 3; ++j) {
                TestEagerBidiSQL.assertEquals((String)("oneToManyChild" + (i + 1) + "::" + (j + 1)), (String)((BidiParent)res.get(i)).getOneToManyChildren().get(j).getName());
                TestEagerBidiSQL.assertEquals(res.get(i), (Object)((BidiParent)res.get(i)).getOneToManyChildren().get(j).getOneToManyParent());
            }
        }
        TestEagerBidiSQL.assertEquals((int)2, (int)this.sql.size());
        em.close();
    }

    public void testEagerOwnerOneToOneQuery() {
        this.sql.clear();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAQuery q = em.createQuery("SELECT o FROM BidiParent o ORDER BY o.name ASC");
        q.getFetchPlan().addField(BidiParent.class, "oneToOneChild");
        q.getFetchPlan().addField(BidiChild.class, "oneToOneParent");
        List res = q.getResultList();
        TestEagerBidiSQL.assertEquals((int)2, (int)res.size());
        TestEagerBidiSQL.assertEquals((int)1, (int)this.sql.size());
        this.assertNotSQL(".* LEFT OUTER JOIN BidiParent .*");
        for (int i = 0; i < res.size(); ++i) {
            TestEagerBidiSQL.assertEquals((String)("parent" + (i + 1)), (String)((BidiParent)res.get(i)).getName());
            TestEagerBidiSQL.assertNotNull((Object)((BidiParent)res.get(i)).getOneToOneChild());
            TestEagerBidiSQL.assertEquals((String)("oneToOneChild" + (i + 1)), (String)((BidiParent)res.get(i)).getOneToOneChild().getName());
            TestEagerBidiSQL.assertEquals(res.get(i), (Object)((BidiParent)res.get(i)).getOneToOneChild().getOneToOneParent());
        }
        TestEagerBidiSQL.assertEquals((int)1, (int)this.sql.size());
        em.close();
    }

    public void testEagerNonOwnerOneToOneQuery() {
        this.sql.clear();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAQuery q = em.createQuery("SELECT o FROM BidiParent o ORDER BY o.name ASC");
        q.getFetchPlan().addField(BidiParent.class, "oneToOneChild");
        q.getFetchPlan().addField(BidiChild.class, "oneToManyParent");
        List res = q.getResultList();
        TestEagerBidiSQL.assertEquals((int)2, (int)res.size());
        TestEagerBidiSQL.assertEquals((int)1, (int)this.sql.size());
        this.assertSQL(".* LEFT OUTER JOIN BidiParent .*");
        for (int i = 0; i < res.size(); ++i) {
            TestEagerBidiSQL.assertEquals((String)("parent" + (i + 1)), (String)((BidiParent)res.get(i)).getName());
            TestEagerBidiSQL.assertNotNull((Object)((BidiParent)res.get(i)).getOneToOneChild());
            TestEagerBidiSQL.assertEquals((String)("oneToOneChild" + (i + 1)), (String)((BidiParent)res.get(i)).getOneToOneChild().getName());
            TestEagerBidiSQL.assertNull((Object)((BidiParent)res.get(i)).getOneToOneChild().getOneToManyParent());
        }
        TestEagerBidiSQL.assertEquals((int)1, (int)this.sql.size());
        em.close();
    }

    public static void main(String[] args) {
        TestRunner.run(TestEagerBidiSQL.class);
    }
}

