/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.relations;

import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.relations.ChainEntityA;
import org.apache.openjpa.persistence.relations.ChainEntityB;
import org.apache.openjpa.persistence.relations.ChainEntityC;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestChainEntities
extends SingleEMFTestCase {
    private static final int MAGICAL_NUMBER = 50;
    long aid;

    public void setUp() {
        this.setUp(DROP_TABLES, ChainEntityA.class, ChainEntityB.class, ChainEntityC.class);
        ChainEntityA a = new ChainEntityA();
        a.setName("TEST_A");
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)a);
        this.aid = a.getId();
        em.getTransaction().commit();
        em.close();
    }

    public void testChainEntities() {
        this.chainUpdate();
    }

    protected void chainUpdate() {
        ChainEntityA a = this.getA();
        ChainEntityB b = new ChainEntityB();
        b.setName("Test_B_");
        for (int i = 1; i <= 50; ++i) {
            ChainEntityC c = new ChainEntityC();
            c.setName("Test_C_" + i);
            b.addChainEntityC(c);
        }
        a.addChildEntityB(b);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        a = (ChainEntityA)em.merge((Object)a);
        em.getTransaction().commit();
        em.close();
    }

    protected ChainEntityA getA() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        ChainEntityA a = (ChainEntityA)em.find(ChainEntityA.class, (Object)this.aid);
        em.close();
        return a;
    }

    protected void dump(ChainEntityA testA) {
        System.out.println("-------");
        System.out.println(testA.getName() + "[" + testA.getId() + "]");
        for (ChainEntityB testB : testA.getChildren()) {
            System.out.println(testB.getName() + "[" + testB.getId() + "]");
            for (ChainEntityC testC : testB.getChainEntityCSet()) {
                System.out.println(testC.getName() + "[" + testC.getId() + "]");
            }
        }
        System.out.println("-------");
    }
}

