/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.relations;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Version;
import org.apache.openjpa.persistence.relations.OneManyEagerChild;
import org.apache.openjpa.persistence.relations.OneManyLazyChild;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class OneManyEagerParent {
    @Id
    @GeneratedValue
    private long id;
    private String name;
    @OneToMany(mappedBy="parent", fetch=FetchType.EAGER)
    @OrderBy(value="name ASC")
    private List<OneManyLazyChild> lazychildren = new ArrayList<OneManyLazyChild>();
    @OneToMany(mappedBy="parent", fetch=FetchType.EAGER)
    @OrderBy(value="name ASC")
    private List<OneManyEagerChild> eagerchildren = new ArrayList<OneManyEagerChild>();
    @Version
    private Integer optLock;

    public long getId() {
        return this.id;
    }

    public List<OneManyLazyChild> getLazyChildren() {
        return this.lazychildren;
    }

    public void addLazyChild(OneManyLazyChild child) {
        child.setParent(this);
        this.lazychildren.add(child);
    }

    public List<OneManyEagerChild> getEagerChildren() {
        return this.eagerchildren;
    }

    public void addEagerChild(OneManyEagerChild child) {
        child.setParent(this);
        this.eagerchildren.add(child);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

