/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.querycache;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NamedQuery;
import org.apache.openjpa.persistence.querycache.common.apps.Entity1;
import org.apache.openjpa.persistence.querycache.common.apps.Entity2;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

@NamedQuery(name="setParam1", query="SELECT o FROM Entity1 o WHERE o.pk = :pk")
public class TestQueryCache
extends SQLListenerTestCase {
    EntityManager em;

    public void setUp() {
        super.setUp(DROP_TABLES, "openjpa.QueryCache", "true", "openjpa.RemoteCommitProvider", "sjvm", Entity1.class, Entity2.class);
        this.em = this.emf.createEntityManager();
        this.em.getTransaction().begin();
        for (int i = 0; i < 10; ++i) {
            Entity1 ent = new Entity1(i, "string" + i, i + 2);
            Entity2 ent2 = new Entity2(i * 2, "ent2" + i, i);
            ent.setEntity2Field(ent2);
            this.em.persist((Object)ent);
        }
        this.em.getTransaction().commit();
    }

    public void testCachedQuery() {
        this.em.createQuery("Select object(o) from Entity1 o").getResultList().get(0);
        this.resetSQL();
        this.em.createQuery("Select object(o) from Entity1 o").getResultList().get(0);
        this.em.createQuery("Select object(o) from Entity1 o").getResultList().get(0);
        TestQueryCache.assertEquals((int)0, (int)this.getSQLCount());
    }

    public void testResultList() {
        List list = this.em.createQuery("Select object(o) from Entity1 o").getResultList();
        TestQueryCache.assertEquals((int)10, (int)list.size());
    }

    public void testGetSingleList() {
        String curr = "2";
        Entity1 ret = (Entity1)this.em.createQuery("SELECT o FROM Entity1 o WHERE o.pk = :pk").setParameter("pk", (Object)Long.valueOf(curr)).getSingleResult();
        TestQueryCache.assertNotNull((Object)ret);
        TestQueryCache.assertEquals((String)"string2", (String)ret.getStringField());
        TestQueryCache.assertEquals((int)4, (int)ret.getIntField());
    }

    public void testExecuteUpdate() {
        String curr = "2";
        String curr2 = "22";
        this.startTx(this.em);
        Entity1 entity1 = (Entity1)this.em.createQuery("SELECT o FROM Entity1 o WHERE o.pk = :pk").setParameter("pk", (Object)Long.valueOf(curr)).getSingleResult();
        int ret = this.em.createQuery("Delete FROM Entity1 o WHERE o.pk = :pk").setParameter("pk", (Object)Long.valueOf(curr)).executeUpdate();
        TestQueryCache.assertEquals((int)ret, (int)1);
        int retTmp = this.em.createQuery("Delete FROM Entity2 o WHERE o.pk = :pk").setParameter("pk", (Object)entity1.getEntity2Field().getPk()).executeUpdate();
        int ret2 = this.em.createQuery("Delete FROM Entity1 o WHERE o.pk = :pk").setParameter("pk", (Object)Long.valueOf(curr2)).executeUpdate();
        TestQueryCache.assertEquals((int)ret2, (int)0);
        this.endTx(this.em);
    }

    public void testSetMaxResults() {
        List l = this.em.createQuery("Select object(o) from Entity1 o").setMaxResults(5).getResultList();
        TestQueryCache.assertNotNull((Object)l);
        TestQueryCache.assertEquals((int)5, (int)l.size());
    }

    public void testSetFirstResults() {
        List l = this.em.createQuery("Select object(o) from Entity1 o").setFirstResult(3).getResultList();
        Entity1 ent = (Entity1)l.get(0);
        TestQueryCache.assertNotNull((Object)ent);
        TestQueryCache.assertEquals((String)"string3", (String)ent.getStringField());
        TestQueryCache.assertEquals((int)5, (int)ent.getIntField());
    }

    protected void startTx(EntityManager em) {
        em.getTransaction().begin();
    }

    protected boolean isActiveTx(EntityManager em) {
        return em.getTransaction().isActive();
    }

    protected void endTx(EntityManager em) {
        if (em.getTransaction().isActive()) {
            if (em.getTransaction().getRollbackOnly()) {
                em.getTransaction().rollback();
            } else {
                em.getTransaction().commit();
            }
        }
    }
}

