/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.query.SimpleEntity;
import org.apache.openjpa.persistence.test.SingleEMTestCase;

public class TestSubstring
extends SingleEMTestCase {
    public void setUp() {
        super.setUp(SimpleEntity.class, CLEAR_TABLES, "openjpa.Compatibility", "JPQL=extended");
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)new SimpleEntity("foo", "bar"));
        em.getTransaction().commit();
        em.close();
    }

    public void testSingleCharacterSubstringInWhere() {
        TestSubstring.assertEquals((Object)1L, (Object)this.em.createQuery("select count(o) from simple o where substring(o.value, 1, 1) = 'b'").getSingleResult());
        TestSubstring.assertEquals((Object)1L, (Object)this.em.createQuery("select count(o) from simple o where substring(o.value, 2, 1) = 'a'").getSingleResult());
        TestSubstring.assertEquals((Object)1L, (Object)this.em.createQuery("select count(o) from simple o where substring(o.value, 3, 1) = 'r'").getSingleResult());
    }

    public void testMultiCharacterSubstringInWhere() {
        TestSubstring.assertEquals((Object)1L, (Object)this.em.createQuery("select count(o) from simple o where substring(o.value, 1, 2) = 'ba'").getSingleResult());
        TestSubstring.assertEquals((Object)1L, (Object)this.em.createQuery("select count(o) from simple o where substring(o.value, 2, 2) = 'ar'").getSingleResult());
    }

    public void testSubstringInSelect() {
        TestSubstring.assertEquals((Object)"b", (Object)this.em.createQuery("select substring(o.value, 1, 1) from simple o").getSingleResult());
        TestSubstring.assertEquals((Object)"a", (Object)this.em.createQuery("select substring(o.value, 2, 1) from simple o").getSingleResult());
        TestSubstring.assertEquals((Object)"r", (Object)this.em.createQuery("select substring(o.value, 3, 1) from simple o").getSingleResult());
    }
}

