/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import java.util.Date;
import java.util.List;
import javax.persistence.TypedQuery;
import org.apache.openjpa.kernel.PreparedQuery;
import org.apache.openjpa.kernel.PreparedQueryCache;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.query.common.apps.QueryTest1;
import org.apache.openjpa.persistence.query.common.apps.QueryTest2;
import org.apache.openjpa.persistence.query.common.apps.QueryTest4;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestQueryResultClassAPI
extends SingleEMFTestCase {
    public void setUp() {
        this.setUp(QueryTest1.class, QueryTest2.class, QueryTest4.class, "openjpa.jdbc.QuerySQLCache", "true", CLEAR_TABLES);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        QueryTest1 pc = null;
        for (int i = 0; i < 10; ++i) {
            pc = new QueryTest1();
            if (i < 5) {
                pc.setNum(4L);
            } else {
                pc.setNum(i + 10);
            }
            pc.setDate(new Date(9999L));
            em.persist((Object)pc);
        }
        em.getTransaction().commit();
        em.close();
    }

    public void testQueryWithResultClass() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String jpql = "SELECT o FROM QueryTest1 o";
        TypedQuery query = em.createQuery(jpql, QueryTest1.class);
        List rs = query.getResultList();
        TestQueryResultClassAPI.assertTrue((boolean)(rs.get(0) instanceof QueryTest1));
        PreparedQuery pq = this.getPreparedQueryCache().get(jpql);
        TestQueryResultClassAPI.assertNotNull((Object)pq);
        TypedQuery query2 = em.createQuery(jpql, QueryTest1.class);
        PreparedQuery pq2 = this.getPreparedQueryCache().get(jpql);
        TestQueryResultClassAPI.assertEquals((Object)pq, (Object)pq2);
        rs = query2.getResultList();
        TestQueryResultClassAPI.assertTrue((boolean)(rs.get(0) instanceof QueryTest1));
        jpql = "SELECT o.datum FROM QueryTest1 o";
        query = em.createQuery(jpql, Date.class);
        rs = query.getResultList();
        TestQueryResultClassAPI.assertTrue((boolean)(rs.get(0) instanceof Date));
        query = em.createNamedQuery("named", QueryTest1.class);
        rs = query.getResultList();
        TestQueryResultClassAPI.assertTrue((boolean)(rs.get(0) instanceof QueryTest1));
        em.close();
    }

    PreparedQueryCache getPreparedQueryCache() {
        return this.emf.getConfiguration().getQuerySQLCacheInstance();
    }
}

