/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Parameter;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.SingularAttribute;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.ParameterImpl;
import org.apache.openjpa.persistence.criteria.OpenJPACriteriaBuilder;
import org.apache.openjpa.persistence.query.SimpleEntity;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestQueryParameters
extends SingleEMFTestCase {
    private static OpenJPAEntityManagerFactorySPI oemf;
    private EntityManager em;

    public void setUp() {
        if (oemf == null) {
            super.setUp(SimpleEntity.class, "openjpa.DynamicEnhancementAgent", "false");
            oemf = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.cast((EntityManagerFactory)this.emf);
        }
        this.em = oemf.createEntityManager();
    }

    public void tearDown() {
    }

    public void testNamedParameterUsingReservedWord() {
        String jpql = "select e from simple e WHERE e.id=:key and e.name=:value";
        Query q = this.em.createQuery(jpql).setParameter("key", (Object)100).setParameter("value", (Object)"XYZ");
        TestQueryParameters.assertEquals((int)2, (int)q.getParameters().size());
        Parameter param1 = q.getParameter("key");
        Parameter param2 = q.getParameter("value");
        TestQueryParameters.assertEquals((Object)100, (Object)q.getParameterValue("key"));
        TestQueryParameters.assertEquals((Object)100, (Object)q.getParameterValue(param1));
        TestQueryParameters.assertEquals((Object)"XYZ", (Object)q.getParameterValue("value"));
        TestQueryParameters.assertEquals((Object)"XYZ", (Object)q.getParameterValue(param2));
        q.getResultList();
    }

    public void testPositionalParameterInJPQLQuery() {
        String jpql = "select e from simple e WHERE e.id=?1 and e.name=?2";
        Query q = this.em.createQuery(jpql).setParameter(1, (Object)100).setParameter(2, (Object)"XYZ");
        TestQueryParameters.assertEquals((int)2, (int)q.getParameters().size());
        Parameter param1 = q.getParameter(1);
        Parameter param2 = q.getParameter(2);
        TestQueryParameters.assertEquals((Object)100, (Object)q.getParameterValue(1));
        TestQueryParameters.assertEquals((Object)100, (Object)q.getParameterValue(param1));
        TestQueryParameters.assertEquals((Object)"XYZ", (Object)q.getParameterValue(2));
        TestQueryParameters.assertEquals((Object)"XYZ", (Object)q.getParameterValue(param2));
        q.getResultList();
    }

    public void testNamedParameterInJPQLQuery() {
        String jpql = "select e from simple e WHERE e.id=:id and e.name=:name";
        Query q = this.em.createQuery(jpql).setParameter("id", (Object)100).setParameter("name", (Object)"XYZ");
        TestQueryParameters.assertEquals((int)2, (int)q.getParameters().size());
        Parameter param1 = q.getParameter("id");
        Parameter param2 = q.getParameter("name");
        TestQueryParameters.assertEquals((Object)100, (Object)q.getParameterValue("id"));
        TestQueryParameters.assertEquals((Object)100, (Object)q.getParameterValue(param1));
        TestQueryParameters.assertEquals((Object)"XYZ", (Object)q.getParameterValue("name"));
        TestQueryParameters.assertEquals((Object)"XYZ", (Object)q.getParameterValue(param2));
        q.getResultList();
    }

    public void testPositionalParameterMissingInJPQLQuery() {
        String jpql = "select e from simple e WHERE e.id=?1 and e.name=?2";
        Query q = this.em.createQuery(jpql).setParameter(1, (Object)100).setParameter(2, (Object)"XYZ");
        this.assertSetParameterFails(q, 3, (Object)100);
    }

    public void testNamedParameterMissingInJPQLQuery() {
        String jpql = "select e from simple e WHERE e.id=:id and e.name=:name";
        Query q = this.em.createQuery(jpql).setParameter("id", (Object)100).setParameter("name", (Object)"XYZ");
        this.assertSetParameterFails(q, "xyz", (Object)100);
    }

    public void testPositionalParameterWrongValueInJPQLQuery() {
        String jpql = "select e from simple e WHERE e.id=?1 and e.name=?2";
        Query q = this.em.createQuery(jpql).setParameter(1, (Object)100).setParameter(2, (Object)"XYZ");
        this.assertSetParameterFails(q, 1, (Object)"XYZ");
        this.assertSetParameterFails(q, 2, (Object)100);
    }

    public void testNamedParameterWrongValueInJPQLQuery() {
        String jpql = "select e from simple e WHERE e.id=:id and e.name=:name";
        Query q = this.em.createQuery(jpql).setParameter("id", (Object)100).setParameter("name", (Object)"XYZ");
        this.assertSetParameterFails(q, "id", (Object)"XYZ");
        this.assertSetParameterFails(q, "name", (Object)100);
    }

    public void testPositionalParameterValueTypeInJPQLQuery() {
        String jpql = "select e from simple e WHERE e.id=?1 and e.name=?2";
        Query q = this.em.createQuery(jpql).setParameter(1, (Object)100).setParameter(2, (Object)"XYZ");
        Parameter param1 = q.getParameter(1);
        TestQueryParameters.assertTrue((boolean)(param1 instanceof ParameterImpl));
        TestQueryParameters.assertEquals(Long.TYPE, (Object)param1.getParameterType());
        Parameter param2 = q.getParameter(2);
        TestQueryParameters.assertTrue((boolean)(param2 instanceof ParameterImpl));
        TestQueryParameters.assertEquals(String.class, (Object)param2.getParameterType());
    }

    public void testNamedParameterValueTypeInJPQLQuery() {
        String jpql = "select e from simple e WHERE e.id=:id and e.name=:name";
        Query q = this.em.createQuery(jpql).setParameter("id", (Object)100).setParameter("name", (Object)"XYZ");
        Parameter param1 = q.getParameter("id");
        TestQueryParameters.assertTrue((boolean)(param1 instanceof ParameterImpl));
        TestQueryParameters.assertEquals(Long.TYPE, (Object)param1.getParameterType());
        Parameter param2 = q.getParameter("name");
        TestQueryParameters.assertTrue((boolean)(param2 instanceof ParameterImpl));
        TestQueryParameters.assertEquals(String.class, (Object)param2.getParameterType());
    }

    public void testNamedParameterInPreparedQuery() {
        String jpql = "select x from simple x WHERE x.id=:id and x.name=:name";
        Query q = this.em.createQuery(jpql).setParameter("id", (Object)100).setParameter("name", (Object)"XYZ");
        q.getResultList();
        TestQueryParameters.assertEquals((String)"javax.persistence.JPQL", (String)OpenJPAPersistence.cast((Query)q).getLanguage());
        Query q2 = this.em.createQuery(jpql).setParameter("id", (Object)200).setParameter("name", (Object)"ZXY");
        TestQueryParameters.assertEquals((String)"openjpa.prepared.SQL", (String)OpenJPAPersistence.cast((Query)q2).getLanguage());
        q2.getResultList();
    }

    public void testPositionalParameterInNamedQuery() {
        Query q = this.em.createNamedQuery("SelectWithPositionalParameter").setParameter(1, (Object)100).setParameter(2, (Object)"XYZ");
        TestQueryParameters.assertEquals((int)2, (int)q.getParameters().size());
        Parameter param1 = q.getParameter(1);
        Parameter param2 = q.getParameter(2);
        TestQueryParameters.assertEquals((Object)100, (Object)q.getParameterValue(1));
        TestQueryParameters.assertEquals((Object)100, (Object)q.getParameterValue(param1));
        TestQueryParameters.assertEquals((Object)"XYZ", (Object)q.getParameterValue(2));
        TestQueryParameters.assertEquals((Object)"XYZ", (Object)q.getParameterValue(param2));
        q.getResultList();
    }

    public void testNamedParameterInNamedQuery() {
        Query q = this.em.createNamedQuery("SelectWithNamedParameter").setParameter("id", (Object)100).setParameter("name", (Object)"XYZ");
        TestQueryParameters.assertEquals((int)2, (int)q.getParameters().size());
        Parameter param1 = q.getParameter("id");
        Parameter param2 = q.getParameter("name");
        TestQueryParameters.assertEquals((Object)100, (Object)q.getParameterValue("id"));
        TestQueryParameters.assertEquals((Object)100, (Object)q.getParameterValue(param1));
        TestQueryParameters.assertEquals((Object)"XYZ", (Object)q.getParameterValue("name"));
        TestQueryParameters.assertEquals((Object)"XYZ", (Object)q.getParameterValue(param2));
        q.getResultList();
    }

    public void testPositionalParameterMissingInNamedQuery() {
        Query q = this.em.createNamedQuery("SelectWithPositionalParameter").setParameter(1, (Object)100).setParameter(2, (Object)"XYZ");
        this.assertSetParameterFails(q, 3, (Object)100);
    }

    public void testNamedParameterMissingInNamedQuery() {
        Query q = this.em.createNamedQuery("SelectWithNamedParameter").setParameter("id", (Object)100).setParameter("name", (Object)"XYZ");
        this.assertSetParameterFails(q, "xyz", (Object)100);
    }

    public void testPositionalParameterWrongValueInNamedQuery() {
        Query q = this.em.createNamedQuery("SelectWithPositionalParameter").setParameter(1, (Object)100).setParameter(2, (Object)"XYZ");
        this.assertSetParameterFails(q, 1, (Object)"XYZ");
        this.assertSetParameterFails(q, 2, (Object)100);
    }

    public void testNamedParameterWrongValueInNamedQuery() {
        Query q = this.em.createNamedQuery("SelectWithNamedParameter").setParameter("id", (Object)100).setParameter("name", (Object)"XYZ");
        this.assertSetParameterFails(q, "id", (Object)"XYZ");
        this.assertSetParameterFails(q, "name", (Object)100);
    }

    public void testPositionalParameterValueTypeInNamedQuery() {
        Query q = this.em.createNamedQuery("SelectWithPositionalParameter").setParameter(1, (Object)100).setParameter(2, (Object)"XYZ");
        Parameter param1 = q.getParameter(1);
        TestQueryParameters.assertTrue((boolean)(param1 instanceof ParameterImpl));
        TestQueryParameters.assertEquals(Long.TYPE, (Object)param1.getParameterType());
        Parameter param2 = q.getParameter(2);
        TestQueryParameters.assertTrue((boolean)(param2 instanceof ParameterImpl));
        TestQueryParameters.assertEquals(String.class, (Object)param2.getParameterType());
    }

    public void testNamedParameterValueTypeInNamedQuery() {
        Query q = this.em.createNamedQuery("SelectWithNamedParameter").setParameter("id", (Object)100).setParameter("name", (Object)"XYZ");
        Parameter param1 = q.getParameter("id");
        TestQueryParameters.assertTrue((boolean)(param1 instanceof ParameterImpl));
        TestQueryParameters.assertEquals(Long.TYPE, (Object)param1.getParameterType());
        Parameter param2 = q.getParameter("name");
        TestQueryParameters.assertTrue((boolean)(param2 instanceof ParameterImpl));
        TestQueryParameters.assertEquals(String.class, (Object)param2.getParameterType());
    }

    public void testCriteriaQueryWithNamedParameter() {
        Metamodel model = oemf.getMetamodel();
        EntityType entity = model.entity(SimpleEntity.class);
        SingularAttribute id = entity.getSingularAttribute("id");
        SingularAttribute name = entity.getSingularAttribute("name");
        OpenJPACriteriaBuilder cb = oemf.getCriteriaBuilder();
        CriteriaQuery c = cb.createQuery(SimpleEntity.class);
        Root root = c.from(SimpleEntity.class);
        ParameterExpression param1 = cb.parameter(Long.TYPE, "id");
        ParameterExpression param2 = cb.parameter(String.class, "name");
        Predicate p1 = cb.equal((Expression)root.get(id), (Expression)param1);
        Predicate p2 = cb.equal((Expression)root.get(name), (Expression)param2);
        c.where((Expression)cb.and((Expression)p1, (Expression)p2));
        TypedQuery q = this.em.createQuery(c);
        TestQueryParameters.assertEquals((int)2, (int)q.getParameters().size());
        TestQueryParameters.assertTrue((boolean)q.getParameters().contains(param1));
        TestQueryParameters.assertTrue((boolean)q.getParameters().contains(param2));
        TestQueryParameters.assertNotNull((Object)q.getParameter("id"));
        TestQueryParameters.assertNotNull((Object)q.getParameter("name"));
    }

    public void testCriteriaQueryWithUnnamedParameter() {
        Metamodel model = oemf.getMetamodel();
        EntityType entity = model.entity(SimpleEntity.class);
        SingularAttribute id = entity.getSingularAttribute("id");
        SingularAttribute name = entity.getSingularAttribute("name");
        OpenJPACriteriaBuilder cb = oemf.getCriteriaBuilder();
        CriteriaQuery c = cb.createQuery(SimpleEntity.class);
        Root root = c.from(SimpleEntity.class);
        ParameterExpression param1 = cb.parameter(Long.TYPE);
        ParameterExpression param2 = cb.parameter(String.class);
        Predicate p1 = cb.equal((Expression)root.get(id), (Expression)param1);
        Predicate p2 = cb.equal((Expression)root.get(name), (Expression)param2);
        c.where((Expression)cb.and((Expression)p1, (Expression)p2));
        TypedQuery q = this.em.createQuery(c);
        TestQueryParameters.assertEquals((int)2, (int)q.getParameters().size());
        TestQueryParameters.assertTrue((boolean)q.getParameters().contains(param1));
        TestQueryParameters.assertTrue((boolean)q.getParameters().contains(param2));
    }

    void assertSetParameterFails(Query q, String name, Object v) {
        try {
            q.setParameter(name, v);
            TestQueryParameters.fail((String)("Expected " + IllegalArgumentException.class.getName()));
        }
        catch (IllegalArgumentException e) {
            System.err.println("Following is expeceted exception, printing to verify error message");
            System.err.println(e);
        }
    }

    void assertSetParameterFails(Query q, int pos, Object v) {
        try {
            q.setParameter(pos, v);
            TestQueryParameters.fail((String)("Expected " + IllegalArgumentException.class.getName()));
        }
        catch (IllegalArgumentException e) {
            System.err.println("Following is expeceted exception, printing to verify error message");
            System.err.println(e);
        }
    }
}

