/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import java.util.List;
import javax.persistence.Query;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.query.SimpleEntity;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestQueryPagination
extends SQLListenerTestCase {
    public void setUp() {
        this.setUp(SimpleEntity.class, CLEAR_TABLES);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)new SimpleEntity("foo", "bar0"));
        em.persist((Object)new SimpleEntity("foo", "bar1"));
        em.persist((Object)new SimpleEntity("foo", "bar2"));
        em.persist((Object)new SimpleEntity("foo", "bar3"));
        em.persist((Object)new SimpleEntity("foo", "bar4"));
        em.persist((Object)new SimpleEntity("foo", "bar5"));
        em.getTransaction().commit();
        em.close();
    }

    public void testFirstThenMax() {
        this.helper(true, 2, 3, 3);
    }

    public void testMaxThenFirst() {
        this.helper(false, 2, 3, 3);
    }

    public void testNoResultsFirstFirst() {
        this.helper(true, 10, 3, 0);
    }

    public void testNoResultsFirstLast() {
        this.helper(false, 10, 3, 0);
    }

    public void testAllResultsFirstFirst() {
        this.helper(true, 0, 10, 6);
    }

    public void testAllResultsFirstLast() {
        this.helper(false, 0, 10, 6);
    }

    private void helper(boolean firstFirst, int first, int max, int expected) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query q = em.createQuery("select e from simple e order by e.value");
        this.sql.clear();
        List fullList = q.getResultList();
        if (firstFirst) {
            q.setFirstResult(first).setMaxResults(max);
        } else {
            q.setMaxResults(max).setFirstResult(first);
        }
        List list = q.getResultList();
        this.checkSQL();
        TestQueryPagination.assertEquals((int)expected, (int)list.size());
        for (int i = 0; i < list.size(); ++i) {
            TestQueryPagination.assertEquals((String)("bar" + (first + i)), (String)((SimpleEntity)list.get(i)).getValue());
        }
        em.close();
    }

    private void checkSQL() {
        TestQueryPagination.assertEquals((int)2, (int)this.sql.size());
        String noRange = (String)this.sql.get(0);
        String withRange = (String)this.sql.get(1);
        DBDictionary dict = ((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance();
        if (dict.supportsSelectStartIndex || dict.supportsSelectEndIndex) {
            TestQueryPagination.assertNotEquals(noRange, withRange);
        } else {
            TestQueryPagination.assertEquals((String)noRange, (String)withRange);
        }
    }
}

