/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import java.util.List;
import javax.persistence.Query;
import junit.textui.TestRunner;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.query.ManyOneEntity;
import org.apache.openjpa.persistence.query.ManyOneEntitySub;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestQueryExcludingSubclasses
extends SingleEMFTestCase {
    public void setUp() {
        this.setUp(ManyOneEntity.class, ManyOneEntitySub.class);
        ManyOneEntity e1 = new ManyOneEntity();
        e1.setName("e1");
        ManyOneEntity e2 = new ManyOneEntity();
        e2.setName("e2");
        ManyOneEntity invalid = new ManyOneEntity();
        invalid.setName("invalid");
        ManyOneEntitySub esub1 = new ManyOneEntitySub();
        esub1.setName("esub1");
        ManyOneEntitySub esub2 = new ManyOneEntitySub();
        esub2.setName("esub2");
        ManyOneEntitySub invalidsub = new ManyOneEntitySub();
        invalidsub.setName("invalidsub");
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)e1);
        em.persist((Object)e2);
        em.persist((Object)invalid);
        em.persist((Object)esub1);
        em.persist((Object)esub2);
        em.persist((Object)invalidsub);
        em.getTransaction().commit();
        em.close();
    }

    public void testQuery() {
        int i;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query q = em.createQuery("select e from ManyOneEntity e where e.name like 'e%' order by e.name asc");
        List res = q.getResultList();
        TestQueryExcludingSubclasses.assertEquals((int)4, (int)res.size());
        for (i = 0; i < 2; ++i) {
            TestQueryExcludingSubclasses.assertEquals(ManyOneEntity.class, ((ManyOneEntity)res.get(i)).getClass());
            TestQueryExcludingSubclasses.assertEquals((String)("e" + (i + 1)), (String)((ManyOneEntity)res.get(i)).getName());
        }
        for (i = 0; i < 2; ++i) {
            TestQueryExcludingSubclasses.assertEquals(ManyOneEntitySub.class, ((ManyOneEntity)res.get(i + 2)).getClass());
            TestQueryExcludingSubclasses.assertEquals((String)("esub" + (i + 1)), (String)((ManyOneEntity)res.get(i + 2)).getName());
        }
        em.close();
    }

    public void testQueryExcludingSubclasses() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query q = em.createQuery("select e from ManyOneEntity e where e.name like 'e%' order by e.name asc");
        ((OpenJPAQuery)q).setSubclasses(false);
        List res = q.getResultList();
        TestQueryExcludingSubclasses.assertEquals((int)2, (int)res.size());
        for (int i = 0; i < res.size(); ++i) {
            TestQueryExcludingSubclasses.assertEquals(ManyOneEntity.class, ((ManyOneEntity)res.get(i)).getClass());
            TestQueryExcludingSubclasses.assertEquals((String)("e" + (i + 1)), (String)((ManyOneEntity)res.get(i)).getName());
        }
        em.close();
    }

    public static void main(String[] args) {
        TestRunner.run(TestQueryExcludingSubclasses.class);
    }
}

